/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.stone_zone.api;

import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.stone_zone.SZRegistry;
import net.mehvahdjukaar.stone_zone.api.StoneZoneEntrySet;
import net.mehvahdjukaar.stone_zone.api.set.mud.MudType;
import net.mehvahdjukaar.stone_zone.api.set.stone.StoneType;
import net.mehvahdjukaar.stone_zone.misc.HardcodedBlockType;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;

public class StoneZoneModule
extends SimpleModule {
    public StoneZoneModule(String modId, String shortId) {
        super(modId, shortId, "stonezone");
    }

    public ResourceKey<CreativeModeTab> getDedicatedTab() {
        return SZRegistry.MOD_TAB.getKey();
    }

    public String toString() {
        return "StoneZone " + LangBuilder.getReadableName((String)this.modId) + " Module";
    }

    public ResourceLocation makeMyRes(String name) {
        return super.makeMyRes(name);
    }

    public boolean isEntryAlreadyRegistered(String entrySetId, String blockId, BlockType blockType, Registry<?> registry) {
        MudType mudType;
        Boolean hardcoded;
        if (blockType instanceof StoneType) {
            StoneType stoneType = (StoneType)blockType;
            Boolean hardcoded2 = HardcodedBlockType.isStoneBlockAlreadyRegistered(entrySetId, blockId, stoneType, this.modId);
            if (hardcoded2 != null) {
                return hardcoded2;
            }
        } else if (blockType instanceof MudType && (hardcoded = HardcodedBlockType.isMudBlockAlreadyRegistered(entrySetId, blockId, mudType = (MudType)blockType, this.modId)) != null) {
            return hardcoded;
        }
        return super.isEntryAlreadyRegistered(entrySetId, blockId, blockType, registry);
    }

    public void registerItems(Registrator<Item> registry) {
        super.registerItems(registry);
    }

    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((resourceManager, resourceSink) -> this.getEntries().forEach(entrySetParent -> {
            block3: {
                if (entrySetParent instanceof StoneZoneEntrySet) {
                    StoneZoneEntrySet entrySet = (StoneZoneEntrySet)((Object)((Object)entrySetParent));
                    try {
                        entrySet.generateModels(this, resourceManager, resourceSink);
                    }
                    catch (Exception ex) {
                        EveryCompat.LOGGER.error("Failed to generate client resources for EntrySet: {} from module {}:", (Object)entrySet, (Object)this, (Object)ex);
                        if (!PlatHelper.isDev()) break block3;
                        throw ex;
                    }
                }
            }
        }));
    }
}

