/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.gui;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.api.EnumSearchPrefix;
import com.lothrazar.storagenetwork.api.IGuiNetwork;
import com.lothrazar.storagenetwork.gui.ISearchHandler;
import com.lothrazar.storagenetwork.gui.NetworkScreenSize;
import com.lothrazar.storagenetwork.gui.TileableTexture;
import com.lothrazar.storagenetwork.gui.components.ButtonRequest;
import com.lothrazar.storagenetwork.gui.slot.ItemSlotNetwork;
import com.lothrazar.storagenetwork.network.ClearRecipeMessage;
import com.lothrazar.storagenetwork.network.InsertMessage;
import com.lothrazar.storagenetwork.network.RequestMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.fml.ModList;

public class NetworkWidget {
    public static List<ISearchHandler> searchHandlers = new ArrayList<ISearchHandler>();
    protected static final Button.CreateNarration DEFAULT_NARRATION = supplier -> (MutableComponent)supplier.get();
    public ItemStack stackUnderMouse = ItemStack.f_41583_;
    public List<ItemStack> stacks;
    public EditBox searchBar;
    public ButtonRequest directionBtn;
    public ButtonRequest sortBtn;
    public ButtonRequest jeiBtn;
    public ButtonRequest focusBtn;
    public ButtonRequest clearGridBtn;
    private List<ItemSlotNetwork> slots;
    private final IGuiNetwork gui;
    private long lastClick;
    private int page = 1;
    private int maxPage = 1;
    private int lines = 4;
    private int columns = 9;
    public int scrollHeight = 152;
    public int scrollWidth = 176;
    public int xNetwork = 8;
    public int yNetwork = 10;
    private final NetworkScreenSize size;
    protected static final int W = 256;
    public static final TileableTexture head = new TileableTexture(new ResourceLocation("storagenetwork", "textures/gui/expandable_head.png"), 256, 10);
    public static final TileableTexture head_right = new TileableTexture(new ResourceLocation("storagenetwork", "textures/gui/expandable_head_right.png"), 256, 10);
    public static final TileableTexture row = new TileableTexture(new ResourceLocation("storagenetwork", "textures/gui/expandable_row.png"), 256, 18);
    public static final TileableTexture row_right = new TileableTexture(new ResourceLocation("storagenetwork", "textures/gui/expandable_row_right.png"), 256, 18);
    public static final TileableTexture crafting = new TileableTexture(new ResourceLocation("storagenetwork", "textures/gui/expandable_crafting.png"), 256, 66);
    public static final TileableTexture crafting_right = new TileableTexture(new ResourceLocation("storagenetwork", "textures/gui/expandable_crafting_right.png"), 256, 66);
    public static final TileableTexture player = new TileableTexture(new ResourceLocation("storagenetwork", "textures/gui/expandable_player.png"), 176, 84);

    public NetworkWidget(IGuiNetwork gui, NetworkScreenSize size) {
        this.gui = gui;
        this.stacks = Lists.newArrayList();
        this.slots = Lists.newArrayList();
        this.size = size;
        this.setScreenSize();
        PacketRegistry.INSTANCE.sendToServer((Object)new RequestMessage());
        this.lastClick = System.currentTimeMillis();
    }

    private void setScreenSize() {
        int buffer = 0;
        this.setLines(this.size.lines());
        this.setColumns(this.size.columns());
        switch (this.size) {
            case NORMAL: {
                buffer = 59;
                break;
            }
            case LARGE: {
                break;
            }
            case EXPANDED: {
                buffer = -10;
                this.xNetwork = 10;
                this.scrollWidth = 472;
            }
        }
        this.scrollHeight = 19 * this.getLines() + buffer;
    }

    public void init(Font font) {
        int x = this.gui.getGuiLeft() + 81;
        int y = this.gui.getGuiTop();
        switch (this.size) {
            case NORMAL: {
                y += 96;
                break;
            }
            case LARGE: {
                y += 160;
                break;
            }
            case EXPANDED: {
                x += 80;
                y += 396;
            }
        }
        Objects.requireNonNull(font);
        this.searchBar = new EditBox(font, x, y, 85, 9, null);
        this.searchBar.m_94199_(30);
        this.searchBar.m_94182_(false);
        this.searchBar.m_94194_(true);
        this.searchBar.m_94202_(0xFFFFFF);
        if (ModList.get().isLoaded("jei")) {
            this.initJei();
        }
        x = this.gui.getGuiLeft() + 6;
        y = this.searchBar.m_252907_() - 4;
        if (this.size == NetworkScreenSize.EXPANDED) {
            x += 155;
            y += 16;
        }
        this.directionBtn = new ButtonRequest(x, y, "", p -> {
            this.gui.setDownwards(!this.gui.getDownwards());
            this.gui.syncDataToServer();
        }, DEFAULT_NARRATION);
        this.directionBtn.setHeight(16);
        this.sortBtn = new ButtonRequest(x += 16, y, "", p -> {
            this.gui.setSort(this.gui.getSort().next());
            this.gui.syncDataToServer();
        }, DEFAULT_NARRATION);
        this.sortBtn.setHeight(16);
        x += 16;
        if (ModList.get().isLoaded("jei")) {
            this.jeiBtn = new ButtonRequest(x, y, "", p -> {
                this.gui.setJeiSearchSynced(!this.gui.isJeiSearchSynced());
                this.gui.syncDataToServer();
            }, DEFAULT_NARRATION);
            this.jeiBtn.setHeight(16);
        }
        x = this.searchBar.m_252754_() + this.searchBar.m_5711_() + 2;
        y = this.searchBar.m_252907_() - 2;
        this.focusBtn = new ButtonRequest(x, y, "", p -> {
            this.gui.setAutoFocus(!this.gui.getAutoFocus());
            this.gui.syncDataToServer();
        }, DEFAULT_NARRATION);
        this.focusBtn.setHeight(11);
        this.focusBtn.m_93674_(6);
        if (this.getSize() != NetworkScreenSize.LARGE) {
            x = this.searchBar.m_252754_() - 19;
            y = this.searchBar.m_252907_() + 13;
            if (this.getSize() == NetworkScreenSize.EXPANDED) {
                x = this.searchBar.m_252754_() - 99;
                y = this.searchBar.m_252907_() - 2;
            }
            this.clearGridBtn = new ButtonRequest(x, y, "", p -> {
                PacketRegistry.INSTANCE.sendToServer((Object)new ClearRecipeMessage());
                PacketRegistry.INSTANCE.sendToServer((Object)new RequestMessage(0, ItemStack.f_41583_, false, false));
            }, DEFAULT_NARRATION);
            this.clearGridBtn.setHeight(7);
            this.clearGridBtn.m_93674_(7);
            this.clearGridBtn.setTextureId(ButtonRequest.TextureEnum.CRAFTCLEAR);
        }
    }

    public List<ItemStack> getStacks() {
        return this.stacks;
    }

    public void setStacks(List<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public NetworkScreenSize getSize() {
        return this.size;
    }

    public void applySearchTextToSlots() {
        ArrayList stacksToDisplay;
        String searchText = this.searchBar.m_94155_();
        ArrayList arrayList = stacksToDisplay = searchText.equals("") ? Lists.newArrayList(this.stacks) : Lists.newArrayList();
        if (!searchText.equals("")) {
            for (ItemStack stack : this.stacks) {
                if (!this.doesStackMatchSearch(stack)) continue;
                stacksToDisplay.add(stack);
            }
        }
        this.sortStackWrappers(stacksToDisplay);
        this.applyScrollPaging(stacksToDisplay);
        this.rebuildItemSlots(stacksToDisplay);
    }

    public void clearSearch() {
        if (this.searchBar == null) {
            return;
        }
        this.searchBar.m_94144_("");
        if (ModList.get().isLoaded("jei") && this.gui.isJeiSearchSynced()) {
            searchHandlers.forEach(handler -> handler.setSearch(""));
        }
    }

    private boolean doesStackMatchSearch(ItemStack stack) {
        String searchText = this.searchBar.m_94155_();
        if (searchText.startsWith(EnumSearchPrefix.MOD.getPrefix())) {
            String name = UtilTileEntity.getModNameForItem(stack.m_41720_());
            return name.toLowerCase().contains(searchText.toLowerCase().substring(1));
        }
        if (searchText.startsWith(EnumSearchPrefix.TOOLTIP.getPrefix())) {
            Minecraft mc = Minecraft.m_91087_();
            List tooltip = stack.m_41651_((Player)mc.f_91074_, (TooltipFlag)TooltipFlag.Default.f_256752_);
            List unformattedTooltip = tooltip.stream().map(Component::getString).collect(Collectors.toList());
            String tooltipString = Joiner.on((char)' ').join(unformattedTooltip).toLowerCase().trim();
            return tooltipString.contains(searchText.toLowerCase().substring(1));
        }
        if (searchText.startsWith(EnumSearchPrefix.TAG.getPrefix())) {
            ArrayList<String> joiner = new ArrayList<String>();
            for (ResourceLocation oreId : stack.m_204131_().map(tagKey -> tagKey.f_203868_()).toList()) {
                String oreName = oreId.toString();
                joiner.add(oreName);
            }
            String dictFinal = Joiner.on((char)' ').join(joiner).toLowerCase().trim();
            return dictFinal.contains(searchText.toLowerCase().substring(1));
        }
        return stack.m_41786_().getString().toLowerCase().contains(searchText.toLowerCase());
    }

    public boolean canClick() {
        return System.currentTimeMillis() > this.lastClick + 100L;
    }

    public int getLines() {
        return this.lines;
    }

    int getColumns() {
        return this.columns;
    }

    void setColumns(int c) {
        this.columns = c;
    }

    public void setLines(int v) {
        this.lines = v;
    }

    public void applyScrollPaging(List<ItemStack> stacksToDisplay) {
        this.maxPage = stacksToDisplay.size() / this.getColumns();
        if (stacksToDisplay.size() % this.getColumns() != 0) {
            ++this.maxPage;
        }
        this.maxPage -= this.getLines() - 1;
        if (this.maxPage < 1) {
            this.maxPage = 1;
        }
        if (this.page < 1) {
            this.page = 1;
        }
        if (this.page > this.maxPage) {
            this.page = this.maxPage;
        }
    }

    public void mouseScrolled(double mouseButton) {
        if (mouseButton > 0.0 && this.page > 1) {
            --this.page;
        }
        if (mouseButton < 0.0 && this.page < this.maxPage) {
            ++this.page;
        }
    }

    public void rebuildItemSlots(List<ItemStack> stacksToDisplay) {
        this.slots = Lists.newArrayList();
        int index = (this.page - 1) * this.getColumns();
        for (int row = 0; row < this.getLines(); ++row) {
            for (int col = 0; col < this.getColumns() && index < stacksToDisplay.size(); ++col) {
                int in = index++;
                this.slots.add(new ItemSlotNetwork(this.gui, stacksToDisplay.get(in), this.gui.getGuiLeft() + this.xNetwork + col * 18, this.gui.getGuiTop() + this.yNetwork + row * 18, stacksToDisplay.get(in).m_41613_(), this.gui.getGuiLeft(), this.gui.getGuiTop(), true));
            }
        }
    }

    public boolean inSearchBar(double mouseX, double mouseY) {
        return this.gui.isInRegion(this.searchBar.m_252754_() - this.gui.getGuiLeft(), this.searchBar.m_252907_() - this.gui.getGuiTop(), this.searchBar.m_5711_(), this.searchBar.m_93694_(), mouseX, mouseY);
    }

    private void initJei() {
        try {
            if (this.gui != null && this.searchBar != null && this.gui.isJeiSearchSynced()) {
                Optional<String> searchResult = searchHandlers.stream().map(ISearchHandler::getSearch).findFirst();
                searchResult.ifPresent(s -> this.searchBar.m_94144_(s));
            }
        }
        catch (Exception e) {
            StorageNetworkMod.LOGGER.error("Search bar error ", (Throwable)e);
        }
    }

    public void syncTextToJei() {
        if (ModList.get().isLoaded("jei") && this.gui.isJeiSearchSynced()) {
            searchHandlers.forEach(handler -> handler.setSearch(this.searchBar.m_94155_()));
        }
    }

    public void drawGuiContainerForegroundLayer(GuiGraphics ms, int mouseX, int mouseY, Font font) {
        for (ItemSlotNetwork slot : this.slots) {
            if (slot == null || !slot.isMouseOverSlot(mouseX, mouseY)) continue;
            slot.drawTooltip(ms, mouseX, mouseY);
            return;
        }
        MutableComponent tooltip = null;
        if (this.directionBtn != null && this.directionBtn.m_5953_(mouseX, mouseY)) {
            tooltip = Component.m_237115_((String)"gui.storagenetwork.sort");
        } else if (this.sortBtn != null && this.sortBtn.m_5953_(mouseX, mouseY)) {
            tooltip = Component.m_237115_((String)("gui.storagenetwork.req.tooltip_" + this.gui.getSort().name().toLowerCase()));
        } else if (this.clearGridBtn != null && this.clearGridBtn.m_5953_(mouseX, mouseY)) {
            tooltip = Component.m_237115_((String)"gui.storagenetwork.req.tooltip_cleargrid");
        } else if (this.focusBtn != null && this.focusBtn.m_5953_(mouseX, mouseY)) {
            tooltip = Component.m_237115_((String)("gui.storagenetwork.autofocus.tooltip." + this.gui.getAutoFocus()));
        } else if (ModList.get().isLoaded("jei") && this.jeiBtn != null && this.jeiBtn.m_5953_(mouseX, mouseY)) {
            tooltip = Component.m_237115_((String)(this.gui.isJeiSearchSynced() ? "gui.storagenetwork.fil.tooltip_jei_on" : "gui.storagenetwork.fil.tooltip_jei_off"));
        } else if (this.inSearchBar(mouseX, mouseY)) {
            if (!Screen.m_96638_()) {
                tooltip = Component.m_237115_((String)"gui.storagenetwork.shift");
            } else {
                ArrayList lis = Lists.newArrayList();
                lis.add(Component.m_237115_((String)"gui.storagenetwork.fil.tooltip_mod"));
                lis.add(Component.m_237115_((String)"gui.storagenetwork.fil.tooltip_tooltip"));
                lis.add(Component.m_237115_((String)"gui.storagenetwork.fil.tooltip_tags"));
                lis.add(Component.m_237115_((String)"gui.storagenetwork.fil.tooltip_clear"));
                ms.m_280677_(font, (List)lis, Optional.empty(), mouseX - this.gui.getGuiLeft(), mouseY - this.gui.getGuiTop());
                return;
            }
        }
        if (tooltip != null) {
            ms.m_280677_(font, (List)Lists.newArrayList((Object[])new Component[]{tooltip}), Optional.empty(), mouseX - this.gui.getGuiLeft(), mouseY - this.gui.getGuiTop());
        }
    }

    public void renderItemSlots(GuiGraphics ms, int mouseX, int mouseY, Font font) {
        this.stackUnderMouse = ItemStack.f_41583_;
        for (ItemSlotNetwork slot : this.slots) {
            slot.drawSlot(ms, font, mouseX, mouseY);
            if (!slot.isMouseOverSlot(mouseX, mouseY)) continue;
            this.stackUnderMouse = slot.getStack();
        }
        if (this.slots.isEmpty()) {
            this.stackUnderMouse = ItemStack.f_41583_;
        }
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.searchBar.m_93696_() && this.searchBar.m_5534_(typedChar, keyCode)) {
            PacketRegistry.INSTANCE.sendToServer((Object)new RequestMessage(0, ItemStack.f_41583_, false, false));
            this.syncTextToJei();
            return true;
        }
        return false;
    }

    public void mouseClicked(double mouseX, double mouseY, int mouseButton) {
        LocalPlayer player;
        this.searchBar.m_93692_(false);
        if (this.inSearchBar(mouseX, mouseY)) {
            this.searchBar.m_93692_(true);
            if (mouseButton == 1) {
                this.clearSearch();
                return;
            }
        }
        if ((player = Minecraft.m_91087_().f_91074_) == null || !this.canClick()) {
            return;
        }
        ItemStack stackCarriedByMouse = player.f_36096_.m_142621_();
        if (!this.stackUnderMouse.m_41619_() && (mouseButton == 0 || mouseButton == 1) && stackCarriedByMouse.m_41619_()) {
            PacketRegistry.INSTANCE.sendToServer((Object)new RequestMessage(mouseButton, this.stackUnderMouse.m_41777_(), Screen.m_96638_(), Screen.m_96639_() || Screen.m_96637_()));
            this.lastClick = System.currentTimeMillis();
        } else if (!stackCarriedByMouse.m_41619_() && this.inField((int)mouseX, (int)mouseY)) {
            PacketRegistry.INSTANCE.sendToServer((Object)new InsertMessage(0, mouseButton));
            this.lastClick = System.currentTimeMillis();
        }
    }

    private boolean inField(int mouseX, int mouseY) {
        int fieldHeight = 0;
        switch (this.size) {
            case NORMAL: {
                fieldHeight = 90;
                break;
            }
            case LARGE: {
                fieldHeight = 172;
                break;
            }
            case EXPANDED: {
                fieldHeight = 390;
            }
        }
        boolean inField = mouseX > this.gui.getGuiLeft() + 7 && mouseX < this.gui.getGuiLeft() + this.scrollWidth - 7 && mouseY > this.gui.getGuiTop() + 7 && mouseY < this.gui.getGuiTop() + fieldHeight;
        return inField;
    }

    public void sortStackWrappers(List<ItemStack> stacksToDisplay) {
        Collections.sort(stacksToDisplay, new Comparator<ItemStack>(){
            final int mul;
            {
                this.mul = NetworkWidget.this.gui.getDownwards() ? -1 : 1;
            }

            @Override
            public int compare(ItemStack o2, ItemStack o1) {
                switch (NetworkWidget.this.gui.getSort()) {
                    case AMOUNT: {
                        return Integer.compare(o1.m_41613_(), o2.m_41613_()) * this.mul;
                    }
                    case NAME: {
                        return o2.m_41786_().getString().compareToIgnoreCase(o1.m_41786_().getString()) * this.mul;
                    }
                    case MOD: {
                        return UtilTileEntity.getModNameForItem(o2.m_41720_()).compareToIgnoreCase(UtilTileEntity.getModNameForItem(o1.m_41720_())) * this.mul;
                    }
                }
                return 0;
            }
        });
    }

    public void render() {
        switch (this.gui.getSort()) {
            case AMOUNT: {
                this.sortBtn.setTextureId(ButtonRequest.TextureEnum.SORT_AMT);
                break;
            }
            case MOD: {
                this.sortBtn.setTextureId(ButtonRequest.TextureEnum.SORT_MOD);
                break;
            }
            case NAME: {
                this.sortBtn.setTextureId(ButtonRequest.TextureEnum.SORT_NAME);
            }
        }
        if (this.clearGridBtn != null) {
            // empty if block
        }
        this.focusBtn.setTextureId(this.gui.getAutoFocus() ? ButtonRequest.TextureEnum.RED : ButtonRequest.TextureEnum.GREY);
        this.directionBtn.setTextureId(this.gui.getDownwards() ? ButtonRequest.TextureEnum.SORT_DOWN : ButtonRequest.TextureEnum.SORT_UP);
        if (this.jeiBtn != null && ModList.get().isLoaded("jei")) {
            this.jeiBtn.setTextureId(this.gui.isJeiSearchSynced() ? ButtonRequest.TextureEnum.JEI_GREEN : ButtonRequest.TextureEnum.JEI_RED);
        }
    }

    protected void blitSegment(GuiGraphics ms, TileableTexture tt, int xpos, int ypos) {
        ms.m_280218_(tt.texture(), xpos, ypos, 0, 0, tt.width(), tt.height());
    }

    public void renderBgExpanded(GuiGraphics ms, float partialTicks, int mouseX, int mouseY, int xCenter, int yCenter) {
        int xpos = xCenter;
        int ypos = yCenter;
        this.blitSegment(ms, head, xpos, ypos);
        this.blitSegment(ms, head_right, xpos + 256, ypos);
        ypos += head.height();
        for (int line = 0; line < this.getLines(); ++line) {
            this.blitSegment(ms, row, xpos, ypos);
            this.blitSegment(ms, row_right, xpos + 256, ypos);
            ypos += row.height();
        }
        this.blitSegment(ms, crafting, xpos, ypos);
        this.blitSegment(ms, crafting_right, xpos + 256, ypos);
        this.blitSegment(ms, player, xpos, ypos += crafting.height() - 4);
    }
}

