/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.capability.handler;

import com.lothrazar.library.cap.ItemStackHandlerEx;
import com.lothrazar.storagenetwork.api.IItemStackMatcher;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class FilterItemStackHandler
extends ItemStackHandlerEx {
    public static final int FILTER_SIZE = 18;
    public boolean tags = false;
    public boolean nbt = false;
    public boolean isAllowList = true;

    public FilterItemStackHandler() {
        super(18);
    }

    public FilterItemStackHandler(int size) {
        super(size);
    }

    public void setMatchOreDict(boolean ores) {
        this.tags = ores;
    }

    public void setMatchNbt(boolean nbt) {
        this.nbt = nbt;
    }

    public void setIsAllowlist(boolean is) {
        this.isAllowList = is;
    }

    protected int getStackLimit(int slot, ItemStack stack) {
        return 1;
    }

    public List<IItemStackMatcher> getStackMatchers() {
        return this.getStacks().stream().map(stack -> new ItemStackMatcher((ItemStack)stack, this.tags, this.nbt)).collect(Collectors.toList());
    }

    public void clear() {
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            this.setStackInSlot(slot, ItemStack.f_41583_);
        }
    }

    public boolean exactStackAlreadyInList(ItemStack stack) {
        return this.getStackMatchers().stream().anyMatch(matcher -> matcher.match(stack));
    }

    public IItemStackMatcher getFirstMatcher(ItemStack stack) {
        for (IItemStackMatcher m : this.getStackMatchers()) {
            if (!m.match(stack)) continue;
            return m;
        }
        return null;
    }

    public boolean isStackFiltered(ItemStack stack) {
        if (this.isAllowList) {
            return this.getStackMatchers().stream().noneMatch(matcher -> matcher.match(stack));
        }
        return this.getStackMatchers().stream().anyMatch(matcher -> matcher.match(stack));
    }

    public boolean allAreEmpty() {
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            if (this.getStackInSlot(slot).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        CompoundTag rulesTag = nbt.m_128469_("rules");
        this.tags = rulesTag.m_128471_("tags");
        this.nbt = rulesTag.m_128471_("nbt");
        this.isAllowList = rulesTag.m_128471_("whitelist");
    }

    public CompoundTag serializeNBT() {
        CompoundTag result = super.serializeNBT();
        CompoundTag rulesTag = new CompoundTag();
        rulesTag.m_128379_("tags", this.tags);
        rulesTag.m_128379_("nbt", this.nbt);
        rulesTag.m_128379_("whitelist", this.isAllowList);
        result.m_128365_("rules", (Tag)rulesTag);
        return result;
    }

    public int getStackCount(ItemStack stackCurrent) {
        int s = 0;
        for (IItemStackMatcher m : this.getStackMatchers()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stackCurrent, (ItemStack)m.getStack())) continue;
            return s += m.getStack().m_41613_();
        }
        return s;
    }
}

