/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.main;

import com.lothrazar.library.block.EntityBlockFlib;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class BlockMain
extends EntityBlockFlib {
    public BlockMain() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(0.5f).m_60918_(SoundType.f_56742_));
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tileAtPos;
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (!worldIn.f_46443_ && (tileAtPos = worldIn.m_7702_(pos)) instanceof TileMain) {
            TileMain main = (TileMain)tileAtPos;
            main.getNetwork().setShouldRefresh();
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult result) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileHere = worldIn.m_7702_(pos);
        if (!(tileHere instanceof TileMain)) {
            return InteractionResult.PASS;
        }
        if (hand == InteractionHand.MAIN_HAND && playerIn.m_21120_(hand).m_41619_()) {
            this.displayConnections(playerIn, tileHere);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void displayConnections(Player playerIn, BlockEntity tileHere) {
        TileMain tileMain = (TileMain)tileHere;
        int total = tileMain.getNetwork().getConnectableSize();
        if (total == 0) {
            return;
        }
        playerIn.m_213846_((Component)Component.m_237115_((String)(ChatFormatting.LIGHT_PURPLE + UtilTileEntity.lang("chat.main.emptyslots") + tileMain.getNetwork().emptySlots())));
        playerIn.m_213846_((Component)Component.m_237115_((String)(ChatFormatting.DARK_AQUA + UtilTileEntity.lang("chat.main.connectables") + total)));
        List<Map.Entry<String, Integer>> listDisplayStrings = tileMain.getNetwork().getDisplayStrings();
        for (Map.Entry<String, Integer> e : listDisplayStrings) {
            playerIn.m_213846_((Component)Component.m_237115_((String)(ChatFormatting.AQUA + "    " + e.getValue() + ": " + e.getKey())));
        }
    }

    public RenderShape m_7514_(BlockState bs) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BlockMain.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SsnRegistry.Tiles.MASTER.get()), (BlockEntityTicker)(world.f_46443_ ? TileMain::clientTick : TileMain::serverTick));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileMain(pos, state);
    }
}

