/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.collection;

import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.api.IGuiPrivate;
import com.lothrazar.storagenetwork.block.collection.ContainerCollectionFilter;
import com.lothrazar.storagenetwork.capability.handler.FilterItemStackHandler;
import com.lothrazar.storagenetwork.gui.slot.ItemSlotNetwork;
import com.lothrazar.storagenetwork.network.CableIOMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class ScreenCollectionFilter
extends AbstractContainerScreen<ContainerCollectionFilter>
implements IGuiPrivate {
    private final ResourceLocation texture = new ResourceLocation("storagenetwork", "textures/gui/plain_filter.png");
    ContainerCollectionFilter containerCableLink;
    private List<ItemSlotNetwork> itemSlotsGhost;

    public ScreenCollectionFilter(ContainerCollectionFilter containerCableFilter, Inventory inv, Component name) {
        super((AbstractContainerMenu)containerCableFilter, inv, name);
        this.containerCableLink = containerCableFilter;
    }

    @Override
    public void renderStackTooltip(GuiGraphics ms, ItemStack stack, int mousex, int mousey) {
        ms.m_280153_(this.f_96547_, stack, mousex, mousey);
    }

    @Override
    public void drawGradient(GuiGraphics ms, int x, int y, int x2, int y2, int u, int v) {
        ms.m_280024_(x, y, x2, y2, u, v);
    }

    public void m_7856_() {
        super.m_7856_();
    }

    private void sendStackSlot(int value, ItemStack stack) {
        PacketRegistry.INSTANCE.sendToServer((Object)new CableIOMessage(CableIOMessage.CableMessageType.SAVE_FITLER.ordinal(), value, stack));
    }

    public void m_88315_(GuiGraphics ms, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(ms);
        super.m_88315_(ms, mouseX, mouseY, partialTicks);
        this.m_280072_(ms, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics ms, float partialTicks, int mouseX, int mouseY) {
        int xCenter = (this.f_96543_ - this.f_97726_) / 2;
        int yCenter = (this.f_96544_ - this.f_97727_) / 2;
        ms.m_280218_(this.texture, xCenter, yCenter, 0, 0, this.f_97726_, this.f_97727_);
        this.itemSlotsGhost = Lists.newArrayList();
        int rows = 2;
        int cols = 9;
        int index = 0;
        int y = 35;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                ItemStack stack = this.containerCableLink.cap.getFilter().getStackInSlot(index);
                int x = 8 + col * 18;
                this.itemSlotsGhost.add(new ItemSlotNetwork(this, stack, this.f_97735_ + x, this.f_97736_ + y, stack.m_41613_(), this.f_97735_, this.f_97736_, true));
                ++index;
            }
            y += 18;
        }
        for (ItemSlotNetwork s : this.itemSlotsGhost) {
            s.drawSlot(ms, this.f_96547_, mouseX, mouseY);
        }
    }

    public void setFilterItems(List<ItemStack> stacks) {
        FilterItemStackHandler filter = this.containerCableLink.cap.getFilter();
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack s = stacks.get(i);
            filter.setStackInSlot(i, s);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        ItemStack mouse = this.f_96541_.f_91074_.f_36096_.m_142621_();
        for (int i = 0; i < this.itemSlotsGhost.size(); ++i) {
            ItemSlotNetwork slot = this.itemSlotsGhost.get(i);
            if (!slot.isMouseOverSlot((int)mouseX, (int)mouseY)) continue;
            if (!slot.getStack().m_41619_()) {
                if (mouseButton == 1) {
                    int direction = ScreenCollectionFilter.m_96638_() ? -1 : 1;
                    int newCount = Math.min(64, slot.getStack().m_41613_() + direction);
                    if (newCount < 1) {
                        newCount = 1;
                    }
                    slot.getStack().m_41764_(newCount);
                } else {
                    slot.setStack(ItemStack.f_41583_);
                }
                this.sendStackSlot(i, slot.getStack());
                return true;
            }
            ItemStack cpy = mouse.m_41777_();
            cpy.m_41764_(1);
            slot.setStack(cpy);
            this.sendStackSlot(i, cpy);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean isInRegion(int x, int y, int width, int height, double mouseX, double mouseY) {
        return super.m_6774_(x, y, width, height, mouseX, mouseY);
    }
}

