/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.cable.processing;

import com.lothrazar.storagenetwork.block.TileCableWithFacing;
import com.lothrazar.storagenetwork.block.cable.processing.ProcessRequestModel;
import com.lothrazar.storagenetwork.capability.CapabilityConnectableProcessing;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.registry.StorageNetworkCapabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileCableProcess
extends TileCableWithFacing {
    protected CapabilityConnectableProcessing itemStorage;
    private ProcessRequestModel processModel = new ProcessRequestModel();

    public TileCableProcess(BlockPos pos, BlockState state) {
        super((BlockEntityType)SsnRegistry.Tiles.PROCESS_KABEL.get(), pos, state);
        this.itemStorage = new CapabilityConnectableProcessing(this);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.itemStorage.deserializeNBT(compound.m_128469_("capability"));
        this.processModel.readFromNBT(compound);
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("capability", (Tag)this.itemStorage.serializeNBT());
        this.processModel.writeToNBT(compound);
    }

    @Override
    public void setDirection(Direction direction) {
        super.setDirection(direction);
        this.itemStorage.setInventoryFace(direction);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == StorageNetworkCapabilities.PROCESSING_CAPABILITY) {
            LazyOptional cap = LazyOptional.of(() -> this.itemStorage);
            return cap.cast();
        }
        return super.getCapability(capability, facing);
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileCableProcess tile) {
    }

    public static <E extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileCableProcess tile) {
        tile.refreshInventoryDirection();
    }
}

