/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.cable.linkfilter;

import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.api.IGuiPrivate;
import com.lothrazar.storagenetwork.block.cable.inputfilter.ScreenCableImportFilter;
import com.lothrazar.storagenetwork.block.cable.linkfilter.ContainerCableFilter;
import com.lothrazar.storagenetwork.capability.handler.FilterItemStackHandler;
import com.lothrazar.storagenetwork.gui.components.ButtonRequest;
import com.lothrazar.storagenetwork.gui.slot.ItemSlotNetwork;
import com.lothrazar.storagenetwork.network.CableDataMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class ScreenCableFilter
extends AbstractContainerScreen<ContainerCableFilter>
implements IGuiPrivate {
    protected static final Button.CreateNarration DEFAULT_NARRATION = supplier -> (MutableComponent)supplier.get();
    private final ResourceLocation texture = new ResourceLocation("storagenetwork", "textures/gui/cable.png");
    ContainerCableFilter containerCableLink;
    private ButtonRequest btnRedstone;
    private ButtonRequest btnMinus;
    private ButtonRequest btnPlus;
    private ButtonRequest btnAllowIgn;
    private ButtonRequest btnImport;
    private boolean isAllowlist;
    private List<ItemSlotNetwork> itemSlotsGhost;
    public static final int SLOT_SIZE = 18;

    public ScreenCableFilter(ContainerCableFilter containerCableFilter, Inventory inv, Component name) {
        super((AbstractContainerMenu)containerCableFilter, inv, name);
        this.containerCableLink = containerCableFilter;
    }

    public void m_7856_() {
        super.m_7856_();
        this.isAllowlist = this.containerCableLink.cap.getFilter().isAllowList;
        this.btnMinus = (ButtonRequest)this.m_142416_((GuiEventListener)new ButtonRequest(this.f_97735_ + 28, this.f_97736_ + 4, "", p -> this.syncData(-1), DEFAULT_NARRATION));
        this.btnMinus.setTextureId(ButtonRequest.TextureEnum.MINUS);
        this.btnPlus = (ButtonRequest)this.m_142416_((GuiEventListener)new ButtonRequest(this.f_97735_ + 60, this.f_97736_ + 4, "", p -> this.syncData(1), DEFAULT_NARRATION));
        this.btnPlus.setTextureId(ButtonRequest.TextureEnum.PLUS);
        this.btnAllowIgn = (ButtonRequest)this.m_142416_((GuiEventListener)new ButtonRequest(this.f_97735_ + 152, this.f_97736_ + 4, "", p -> {
            this.isAllowlist = !this.isAllowlist;
            this.syncData(0);
        }, DEFAULT_NARRATION));
        this.btnImport = (ButtonRequest)this.m_142416_((GuiEventListener)new ButtonRequest(this.f_97735_ + 120, this.f_97736_ + 4, "", p -> this.importFilterSlots(), DEFAULT_NARRATION));
        this.btnImport.setTextureId(ButtonRequest.TextureEnum.IMPORT);
    }

    private void importFilterSlots() {
        PacketRegistry.INSTANCE.sendToServer((Object)new CableDataMessage(CableDataMessage.CableMessageType.IMPORT_FILTER.ordinal()));
    }

    private void sendStackSlot(int value, ItemStack stack) {
        PacketRegistry.INSTANCE.sendToServer((Object)new CableDataMessage(CableDataMessage.CableMessageType.SAVE_FITLER.ordinal(), value, stack));
    }

    private void syncData(int priority) {
        PacketRegistry.INSTANCE.sendToServer((Object)new CableDataMessage(CableDataMessage.CableMessageType.SYNC_DATA.ordinal(), priority, this.isAllowlist));
    }

    public void m_88315_(GuiGraphics ms, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(ms);
        super.m_88315_(ms, mouseX, mouseY, partialTicks);
        this.btnAllowIgn.setTextureId(this.isAllowlist ? ButtonRequest.TextureEnum.ALLOWLIST : ButtonRequest.TextureEnum.IGNORELIST);
        if (this.containerCableLink == null || this.containerCableLink.cap == null || this.containerCableLink.cap.connectable == null) {
            return;
        }
    }

    public void m_280003_(GuiGraphics ms, int mouseX, int mouseY) {
        int priority = this.containerCableLink.cap.getPriority();
        ms.m_280488_(this.f_96547_, String.valueOf(priority), 50 - this.f_96547_.m_92895_(String.valueOf(priority)) / 2, 12, 0x404040);
        this.drawTooltips(ms, mouseX, mouseY);
    }

    private void drawTooltips(GuiGraphics ms, int mouseX, int mouseY) {
        if (this.btnImport != null && this.btnImport.m_5953_(mouseX, mouseY)) {
            ms.m_280677_(this.f_96547_, (List)Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"gui.storagenetwork.import")}), Optional.empty(), mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (this.btnAllowIgn != null && this.btnAllowIgn.m_5953_(mouseX, mouseY)) {
            ms.m_280677_(this.f_96547_, (List)Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)(this.isAllowlist ? "gui.storagenetwork.allowlist" : "gui.storagenetwork.ignorelist"))}), Optional.empty(), mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (this.btnMinus != null && this.btnMinus.m_5953_(mouseX, mouseY)) {
            ms.m_280677_(this.f_96547_, (List)Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"gui.storagenetwork.priority.down")}), Optional.empty(), mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (this.btnPlus != null && this.btnPlus.m_5953_(mouseX, mouseY)) {
            ms.m_280677_(this.f_96547_, (List)Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"gui.storagenetwork.priority.up")}), Optional.empty(), mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (this.btnRedstone != null && this.btnRedstone.m_5953_(mouseX, mouseY)) {
            ms.m_280677_(this.f_96547_, (List)Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"gui.storagenetwork.redstone")}), Optional.empty(), mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    @Override
    public void renderStackTooltip(GuiGraphics ms, ItemStack stack, int mousex, int mousey) {
        ms.m_280153_(this.f_96547_, stack, mousex, mousey);
    }

    @Override
    public void drawGradient(GuiGraphics ms, int x, int y, int x2, int y2, int u, int v) {
        ms.m_280024_(x, y, x2, y2, u, v);
    }

    protected void m_7286_(GuiGraphics ms, float partialTicks, int mouseX, int mouseY) {
        int xCenter = (this.f_96543_ - this.f_97726_) / 2;
        int yCenter = (this.f_96544_ - this.f_97727_) / 2;
        ms.m_280218_(this.texture, xCenter, yCenter, 0, 0, this.f_97726_, this.f_97727_);
        this.itemSlotsGhost = Lists.newArrayList();
        int rows = 2;
        int cols = 9;
        int index = 0;
        int y = 35;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                ItemStack stack = this.containerCableLink.cap.getFilter().getStackInSlot(index);
                int x = 8 + col * 18;
                this.itemSlotsGhost.add(new ItemSlotNetwork(this, stack, this.f_97735_ + x, this.f_97736_ + y, stack.m_41613_(), this.f_97735_, this.f_97736_, true));
                ++index;
            }
            y += 18;
        }
        for (ItemSlotNetwork s : this.itemSlotsGhost) {
            s.drawSlot(ms, this.f_96547_, mouseX, mouseY);
        }
    }

    public void setFilterItems(List<ItemStack> stacks) {
        FilterItemStackHandler filter = this.containerCableLink.cap.getFilter();
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack s = stacks.get(i);
            filter.setStackInSlot(i, s);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        ItemStack mouse = this.f_96541_.f_91074_.f_36096_.m_142621_();
        for (int i = 0; i < this.itemSlotsGhost.size(); ++i) {
            ItemSlotNetwork slot = this.itemSlotsGhost.get(i);
            if (!slot.isMouseOverSlot((int)mouseX, (int)mouseY)) continue;
            if (!slot.getStack().m_41619_()) {
                if (mouseButton == 1) {
                    int direction = ScreenCableFilter.m_96638_() ? -1 : 1;
                    int newCount = Math.min(64, slot.getStack().m_41613_() + direction);
                    if (newCount < 1) {
                        newCount = 1;
                    }
                    slot.getStack().m_41764_(newCount);
                } else {
                    slot.setStack(ItemStack.f_41583_);
                }
                this.sendStackSlot(i, slot.getStack());
                return true;
            }
            slot.setStack(mouse.m_41777_());
            this.sendStackSlot(i, mouse.m_41777_());
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta != 0.0) {
            for (int i = 0; i < this.itemSlotsGhost.size(); ++i) {
                ItemStack changeme;
                ItemSlotNetwork slot = this.itemSlotsGhost.get(i);
                if (!slot.isMouseOverSlot((int)mouseX, (int)mouseY) || (changeme = ScreenCableImportFilter.scrollStack(delta, slot)) == null) continue;
                this.sendStackSlot(i, changeme);
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    @Override
    public boolean isInRegion(int x, int y, int width, int height, double mouseX, double mouseY) {
        return super.m_6774_(x, y, width, height, mouseX, mouseY);
    }
}

