/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.cable;

import com.google.common.collect.Maps;
import com.lothrazar.library.block.EntityBlockFlib;
import com.lothrazar.library.data.ShapeCache;
import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.api.EnumConnectType;
import com.lothrazar.storagenetwork.api.IConnectable;
import com.lothrazar.storagenetwork.api.IConnectableItemAutoIO;
import com.lothrazar.storagenetwork.block.cable.TileCable;
import com.lothrazar.storagenetwork.capability.CapabilityConnectableAutoIO;
import com.lothrazar.storagenetwork.registry.ConfigRegistry;
import com.lothrazar.storagenetwork.registry.StorageNetworkCapabilities;
import com.lothrazar.storagenetwork.util.ShapeBuilder;
import com.lothrazar.storagenetwork.util.UtilConnections;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class BlockCable
extends EntityBlockFlib
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<EnumConnectType> DOWN = EnumProperty.m_61587_((String)"down", EnumConnectType.class);
    public static final EnumProperty<EnumConnectType> UP = EnumProperty.m_61587_((String)"up", EnumConnectType.class);
    public static final EnumProperty<EnumConnectType> NORTH = EnumProperty.m_61587_((String)"north", EnumConnectType.class);
    public static final EnumProperty<EnumConnectType> SOUTH = EnumProperty.m_61587_((String)"south", EnumConnectType.class);
    public static final EnumProperty<EnumConnectType> WEST = EnumProperty.m_61587_((String)"west", EnumConnectType.class);
    public static final EnumProperty<EnumConnectType> EAST = EnumProperty.m_61587_((String)"east", EnumConnectType.class);
    public static final Map<Direction, EnumProperty<EnumConnectType>> FACING_TO_PROPERTY_MAP = (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), p -> {
        p.put(Direction.NORTH, NORTH);
        p.put(Direction.EAST, EAST);
        p.put(Direction.SOUTH, SOUTH);
        p.put(Direction.WEST, WEST);
        p.put(Direction.UP, UP);
        p.put(Direction.DOWN, DOWN);
    });

    public BlockCable() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(0.2f));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(NORTH, (Comparable)((Object)EnumConnectType.NONE))).m_61124_(EAST, (Comparable)((Object)EnumConnectType.NONE))).m_61124_(SOUTH, (Comparable)((Object)EnumConnectType.NONE))).m_61124_(WEST, (Comparable)((Object)EnumConnectType.NONE))).m_61124_(UP, (Comparable)((Object)EnumConnectType.NONE))).m_61124_(DOWN, (Comparable)((Object)EnumConnectType.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Deprecated
    public boolean m_7357_(BlockState bs, BlockGetter bg, BlockPos pos, PathComputationType path) {
        return false;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity != null) {
                IConnectableItemAutoIO connectable;
                IItemHandler items = (IItemHandler)tileentity.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
                if (items != null) {
                    for (int i = 0; i < items.getSlots(); ++i) {
                        Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)items.getStackInSlot(i));
                    }
                    worldIn.m_46717_(pos, (Block)this);
                }
                if ((connectable = (IConnectableItemAutoIO)tileentity.getCapability(StorageNetworkCapabilities.CONNECTABLE_AUTO_IO).orElse(null)) instanceof CapabilityConnectableAutoIO) {
                    CapabilityConnectableAutoIO filterCable = (CapabilityConnectableAutoIO)connectable;
                    for (int i = 0; i < filterCable.upgrades.getSlots(); ++i) {
                        Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)filterCable.upgrades.getStackInSlot(i));
                    }
                    worldIn.m_46717_(pos, (Block)this);
                }
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public static BlockState cleanBlockState(BlockState state) {
        for (Direction d : Direction.values()) {
            EnumProperty<EnumConnectType> prop = FACING_TO_PROPERTY_MAP.get(d);
            if (state.m_61143_(prop) != EnumConnectType.INVENTORY) continue;
            state = (BlockState)state.m_61124_(prop, (Comparable)((Object)EnumConnectType.NONE));
        }
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        TileCable tile;
        if (((Boolean)ConfigRegistry.enableFacades.get()).booleanValue() && (tile = TileCable.getTileCable(worldIn, pos)) != null && tile.getFacadeState() != null) {
            return tile.getFacadeState().m_60651_(worldIn, pos, context);
        }
        return ShapeCache.getOrCreate((BlockState)state, ShapeBuilder::createShape);
    }

    public RenderShape m_7514_(BlockState bs) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileCable(pos, state);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState stateIn, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, stateIn, placer, stack);
        for (Direction d : Direction.values()) {
            BlockPos posoff = pos.m_121945_(d);
            BlockState facingState = worldIn.m_8055_(posoff);
            if (!UtilConnections.isCableOverride(facingState)) continue;
            StorageNetworkMod.log("Main override setplacedby " + facingState);
            stateIn = (BlockState)stateIn.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(d), (Comparable)((Object)EnumConnectType.CABLE));
            worldIn.m_46597_(pos, stateIn);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        IConnectable cap;
        EnumProperty<EnumConnectType> property = FACING_TO_PROPERTY_MAP.get(facing);
        if (UtilConnections.isCableOverride(facingState)) {
            StorageNetworkMod.log("isCableOverride override " + facingState);
            return (BlockState)stateIn.m_61124_(property, (Comparable)((Object)EnumConnectType.CABLE));
        }
        BlockEntity tileOffset = world.m_7702_(facingPos);
        if (!BlockCable.hasInventoryAlready(stateIn) && UtilConnections.isInventory(facing, world, facingPos)) {
            StorageNetworkMod.log("new Inventory from updateShape " + facingState);
            return (BlockState)stateIn.m_61124_(property, (Comparable)((Object)EnumConnectType.INVENTORY));
        }
        if (tileOffset != null && (cap = (IConnectable)tileOffset.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY).orElse(null)) != null) {
            StorageNetworkMod.log("Normal network item  " + facingState);
            return (BlockState)stateIn.m_61124_(property, (Comparable)((Object)EnumConnectType.CABLE));
        }
        return (BlockState)stateIn.m_61124_(property, (Comparable)((Object)EnumConnectType.NONE));
    }

    private static boolean hasInventoryAlready(BlockState stateIn) {
        for (Direction d : Direction.values()) {
            if (!((EnumConnectType)((Object)stateIn.m_61143_((Property)FACING_TO_PROPERTY_MAP.get(d)))).isInventory()) continue;
            return true;
        }
        return false;
    }
}

