/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.fulleng.forge;

import appeng.api.ids.AECreativeTabIds;
import gripe._90.fulleng.FullblockEnergistics;
import gripe._90.fulleng.block.entity.terminal.PatternEncodingTerminalBlockEntity;
import gripe._90.fulleng.definition.FullEngBlockEntities;
import gripe._90.fulleng.definition.FullEngBlocks;
import gripe._90.fulleng.forge.FullEngClient;
import gripe._90.fulleng.integration.requester.RequesterTerminalMenu;
import gripe._90.fulleng.menu.PatternAccessTerminalMenu;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod(value="fulleng")
public class FullEngForge {
    public FullEngForge() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::registerAll);
        bus.addListener(this::addToCreativeTab);
        MinecraftForge.EVENT_BUS.addGenericListener(BlockEntity.class, this::attachPatternStorageCapability);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> FullEngClient::new);
    }

    private void registerAll(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.BLOCKS.getRegistryKey())) {
            FullEngBlocks.getBlocks().forEach(b -> {
                ForgeRegistries.BLOCKS.register(b.id(), (Object)b.block());
                ForgeRegistries.ITEMS.register(b.id(), (Object)b.m_5456_());
            });
        }
        if (event.getRegistryKey().equals((Object)ForgeRegistries.BLOCK_ENTITY_TYPES.getRegistryKey())) {
            FullEngBlockEntities.getBlockEntities().forEach((arg_0, arg_1) -> ((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES).register(arg_0, arg_1));
        }
        if (event.getRegistryKey().equals((Object)ForgeRegistries.MENU_TYPES.getRegistryKey())) {
            ForgeRegistries.MENU_TYPES.register("appeng:patternaccessterminal_f", PatternAccessTerminalMenu.TYPE_FULLBLOCK);
            if (FullblockEnergistics.PLATFORM.isRequesterLoaded()) {
                ForgeRegistries.MENU_TYPES.register("appeng:requester_terminal_f", RequesterTerminalMenu.TYPE_FULLBLOCK);
            }
        }
    }

    private void addToCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals((Object)AECreativeTabIds.MAIN)) {
            FullEngBlocks.getBlocks().forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).m_246326_(arg_0));
        }
    }

    private void attachPatternStorageCapability(AttachCapabilitiesEvent<BlockEntity> event) {
        Object object = event.getObject();
        if (object instanceof PatternEncodingTerminalBlockEntity) {
            final PatternEncodingTerminalBlockEntity patternTerm = (PatternEncodingTerminalBlockEntity)((Object)object);
            ICapabilityProvider capabilityProvider = new ICapabilityProvider(){
                private final LazyOptional<IItemHandler> patternSlotHandler = LazyOptional.of(() -> patternTerm.getLogic().getBlankPatternInv().toItemHandler());

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction dir) {
                    return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.patternSlotHandler);
                }

                private void invalidate() {
                    this.patternSlotHandler.invalidate();
                }
            };
            event.addCapability(FullblockEnergistics.makeId("pattern_encoding_terminal"), capabilityProvider);
            event.addListener((capabilityProvider)::invalidate);
        }
    }

    public static class Platform
    implements FullblockEnergistics.Platform {
        @Override
        public boolean isRequesterLoaded() {
            return ModList.get().isLoaded("merequester");
        }
    }
}

