/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.fulleng.forge;

import appeng.api.util.AEColor;
import appeng.client.gui.me.patternaccess.PatternAccessTermScreen;
import appeng.client.render.ColorableBlockEntityBlockColor;
import appeng.client.render.StaticItemColor;
import appeng.core.definitions.BlockDefinition;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PartLeftClickPacket;
import appeng.init.client.InitScreens;
import appeng.util.InteractionUtil;
import gripe._90.fulleng.FullblockEnergistics;
import gripe._90.fulleng.block.entity.monitor.ConversionMonitorBlockEntity;
import gripe._90.fulleng.client.MonitorBlockEntityRenderer;
import gripe._90.fulleng.definition.FullEngBlockEntities;
import gripe._90.fulleng.definition.FullEngBlocks;
import gripe._90.fulleng.integration.requester.RequesterIntegration;
import gripe._90.fulleng.menu.PatternAccessTerminalMenu;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class FullEngClient {
    public FullEngClient() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::initScreens);
        bus.addListener(this::initBlockEntityRenders);
        bus.addListener(this::registerColourProviders);
        bus.addListener(this::setRenderLayers);
        MinecraftForge.EVENT_BUS.addListener(this::addConversionMonitorHook);
    }

    private void initScreens(FMLClientSetupEvent ignoredEvent) {
        InitScreens.register(PatternAccessTerminalMenu.TYPE_FULLBLOCK, PatternAccessTermScreen::new, (String)"/screens/pattern_access_terminal.json");
        if (FullblockEnergistics.PLATFORM.isRequesterLoaded()) {
            RequesterIntegration.initScreen();
        }
    }

    private void initBlockEntityRenders(ModelEvent.RegisterGeometryLoaders ignoredEvent) {
        BlockEntityRenderers.m_173590_(FullEngBlockEntities.STORAGE_MONITOR, MonitorBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_(FullEngBlockEntities.CONVERSION_MONITOR, MonitorBlockEntityRenderer::new);
    }

    private void registerColourProviders(RegisterColorHandlersEvent event) {
        for (BlockDefinition<?> block : FullEngBlocks.getBlocks()) {
            if (event instanceof RegisterColorHandlersEvent.Block) {
                RegisterColorHandlersEvent.Block blockEvent = (RegisterColorHandlersEvent.Block)event;
                blockEvent.register((BlockColor)new ColorableBlockEntityBlockColor(), new Block[]{block.block()});
            }
            if (!(event instanceof RegisterColorHandlersEvent.Item)) continue;
            RegisterColorHandlersEvent.Item itemEvent = (RegisterColorHandlersEvent.Item)event;
            itemEvent.register((ItemColor)new StaticItemColor(AEColor.TRANSPARENT), new ItemLike[]{block.block()});
        }
    }

    private void setRenderLayers(FMLClientSetupEvent ignoredEvent) {
        for (BlockDefinition<?> block : FullEngBlocks.getBlocks()) {
            ItemBlockRenderTypes.setRenderLayer((Block)block.block(), (RenderType)RenderType.m_110463_());
        }
    }

    private void addConversionMonitorHook(PlayerInteractEvent.LeftClickBlock event) {
        Level level = event.getLevel();
        if (level.m_5776_()) {
            HitResult hitResult = Minecraft.m_91087_().f_91077_;
            if (!(hitResult instanceof BlockHitResult)) {
                return;
            }
            BlockHitResult hitResult2 = (BlockHitResult)hitResult;
            if (level.m_7702_(hitResult2.m_82425_()) instanceof ConversionMonitorBlockEntity) {
                NetworkHandler.instance().sendToServer((BasePacket)new PartLeftClickPacket(hitResult2, InteractionUtil.isInAlternateUseMode((Player)event.getEntity())));
                Objects.requireNonNull(Minecraft.m_91087_().f_91072_).f_105195_ = 5;
                event.setCanceled(true);
            }
        }
    }
}

