/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.fulleng.block.entity.monitor;

import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IStackWatcher;
import appeng.api.networking.crafting.ICraftingWatcherNode;
import appeng.api.networking.storage.IStorageWatcherNode;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.api.util.INetworkToolAware;
import appeng.core.localization.PlayerMessages;
import gripe._90.fulleng.block.entity.FullBlockEntity;
import gripe._90.fulleng.definition.FullEngBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class StorageMonitorBlockEntity
extends FullBlockEntity
implements INetworkToolAware {
    @Nullable
    private AEKey configuredItem;
    private long amount;
    private boolean canCraft;
    private String lastHumanReadableText;
    private boolean isLocked;
    private IStackWatcher storageWatcher;
    private IStackWatcher craftingWatcher;

    public StorageMonitorBlockEntity(BlockPos pos, BlockState state) {
        this(FullEngBlockEntities.STORAGE_MONITOR, pos, state);
    }

    public StorageMonitorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.getMainNode().addService(IStorageWatcherNode.class, (IGridNodeService)new IStorageWatcherNode(){

            public void updateWatcher(IStackWatcher newWatcher) {
                StorageMonitorBlockEntity.this.storageWatcher = newWatcher;
                StorageMonitorBlockEntity.this.configureWatchers();
            }

            public void onStackChange(AEKey what, long amount) {
                if (what.equals(StorageMonitorBlockEntity.this.configuredItem)) {
                    String humanReadableText;
                    StorageMonitorBlockEntity.this.amount = amount;
                    String string = humanReadableText = amount == 0L && StorageMonitorBlockEntity.this.canCraft ? "Craft" : what.formatAmount(amount, AmountFormat.SLOT);
                    if (!humanReadableText.equals(StorageMonitorBlockEntity.this.lastHumanReadableText)) {
                        StorageMonitorBlockEntity.this.lastHumanReadableText = humanReadableText;
                        StorageMonitorBlockEntity.this.saveChanges();
                        StorageMonitorBlockEntity.this.markForUpdate();
                    }
                }
            }
        });
        this.getMainNode().addService(ICraftingWatcherNode.class, (IGridNodeService)new ICraftingWatcherNode(){

            public void updateWatcher(IStackWatcher newWatcher) {
                StorageMonitorBlockEntity.this.craftingWatcher = newWatcher;
                StorageMonitorBlockEntity.this.configureWatchers();
            }

            public void onRequestChange(AEKey what) {
            }

            public void onCraftableChange(AEKey what) {
                StorageMonitorBlockEntity.this.getMainNode().ifPresent(StorageMonitorBlockEntity.this::updateReportingValue);
            }
        });
    }

    @Override
    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean wasLocked;
        boolean needRedraw = super.readFromStream(data);
        this.isLocked = wasLocked = data.readBoolean();
        if (data.readBoolean()) {
            this.configuredItem = AEKey.readKey((FriendlyByteBuf)data);
            this.amount = data.m_130258_();
            this.canCraft = data.readBoolean();
        } else {
            this.configuredItem = null;
            this.amount = 0L;
            this.canCraft = false;
        }
        return wasLocked != this.isLocked || needRedraw;
    }

    @Override
    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.isLocked);
        data.writeBoolean(this.configuredItem != null);
        if (this.configuredItem != null) {
            AEKey.writeKey((FriendlyByteBuf)data, (AEKey)this.configuredItem);
            data.m_130103_(this.amount);
            data.writeBoolean(this.canCraft);
        }
    }

    @Override
    protected void saveVisualState(CompoundTag data) {
        super.saveVisualState(data);
        data.m_128356_("amount", this.amount);
        data.m_128379_("canCraft", this.canCraft);
    }

    @Override
    protected void loadVisualState(CompoundTag data) {
        super.loadVisualState(data);
        this.amount = data.m_128454_("amount");
        this.canCraft = data.m_128471_("canCraft");
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128379_("isLocked", this.isLocked);
        if (this.configuredItem != null) {
            data.m_128365_("configuredItem", (Tag)this.configuredItem.toTagGeneric());
        }
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.isLocked = data.m_128471_("isLocked");
        this.configuredItem = AEKey.fromTagGeneric((CompoundTag)data.m_128469_("configuredItem"));
    }

    public void onActivated(Player player, InteractionHand hand) {
        if (!this.isLocked) {
            ItemStack eq = player.m_21120_(hand);
            if (AEItemKey.matches((AEKey)this.configuredItem, (ItemStack)eq)) {
                GenericStack containedStack = ContainerItemStrategies.getContainedStack((ItemStack)eq);
                if (containedStack != null) {
                    this.configuredItem = containedStack.what();
                }
            } else {
                this.configuredItem = AEItemKey.of((ItemStack)eq);
            }
            this.configureWatchers();
            this.saveChanges();
            this.markForUpdate();
        }
    }

    public void onShiftActivated(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_41619_()) {
            this.isLocked = !this.isLocked;
            player.m_213846_((Component)(this.isLocked ? PlayerMessages.isNowLocked : PlayerMessages.isNowUnlocked).text());
            this.saveChanges();
            this.markForUpdate();
        }
    }

    private void configureWatchers() {
        if (this.storageWatcher != null) {
            this.storageWatcher.reset();
        }
        if (this.craftingWatcher != null) {
            this.craftingWatcher.reset();
        }
        if (this.configuredItem != null) {
            if (this.storageWatcher != null) {
                this.storageWatcher.add(this.configuredItem);
            }
            if (this.craftingWatcher != null) {
                this.craftingWatcher.add(this.configuredItem);
            }
            this.getMainNode().ifPresent(this::updateReportingValue);
        }
    }

    private void updateReportingValue(IGrid grid) {
        this.lastHumanReadableText = null;
        if (this.configuredItem != null) {
            this.amount = grid.getStorageService().getCachedInventory().get(this.configuredItem);
            this.canCraft = grid.getCraftingService().isCraftable(this.configuredItem);
        } else {
            this.amount = 0L;
            this.canCraft = false;
        }
        this.markForUpdate();
    }

    public AEKey getDisplayed() {
        return this.configuredItem;
    }

    public long getAmount() {
        return this.amount;
    }

    public boolean canCraft() {
        return this.canCraft;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public boolean showNetworkInfo(UseOnContext context) {
        return false;
    }
}

