/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.fulleng.block.entity.monitor;

import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.ISubMenuHost;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.me.helpers.PlayerSource;
import appeng.menu.ISubMenu;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.crafting.CraftAmountMenu;
import appeng.util.inv.PlayerInternalInventory;
import gripe._90.fulleng.block.entity.monitor.StorageMonitorBlockEntity;
import gripe._90.fulleng.definition.FullEngBlockEntities;
import gripe._90.fulleng.definition.FullEngBlocks;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ConversionMonitorBlockEntity
extends StorageMonitorBlockEntity
implements ISubMenuHost {
    public ConversionMonitorBlockEntity(BlockPos pos, BlockState state) {
        super(FullEngBlockEntities.CONVERSION_MONITOR, pos, state);
    }

    @Override
    public void onActivated(Player player, InteractionHand hand) {
        ItemStack eq = player.m_21120_(hand);
        if (this.isLocked()) {
            this.insertItem(player, hand, eq.m_41619_());
        } else if (this.getDisplayed() != null && AEItemKey.matches((AEKey)this.getDisplayed(), (ItemStack)eq)) {
            this.insertItem(player, hand, false);
        } else {
            super.onActivated(player, hand);
        }
    }

    private void insertItem(Player player, InteractionHand hand, boolean allItems) {
        this.getMainNode().ifPresent(grid -> {
            IEnergyService energy = grid.getEnergyService();
            MEStorage cell = grid.getStorageService().getInventory();
            if (allItems) {
                AEKey patt1758$temp = this.getDisplayed();
                if (patt1758$temp instanceof AEItemKey) {
                    AEItemKey itemKey = (AEItemKey)patt1758$temp;
                    PlayerInternalInventory inv = new PlayerInternalInventory(player.m_150109_());
                    for (int x = 0; x < inv.size(); ++x) {
                        ItemStack canExtract;
                        ItemStack targetStack = inv.getStackInSlot(x);
                        if (!itemKey.matches(targetStack) || (canExtract = inv.extractItem(x, targetStack.m_41613_(), true)).m_41619_()) continue;
                        long inserted = StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)cell, (AEKey)itemKey, (long)canExtract.m_41613_(), (IActionSource)new PlayerSource(player, (IActionHost)this));
                        inv.extractItem(x, (int)inserted, false);
                    }
                }
            } else {
                ItemStack input = player.m_21120_(hand);
                if (!input.m_41619_()) {
                    long inserted = StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)cell, (AEKey)((AEKey)Objects.requireNonNull(AEItemKey.of((ItemStack)input))), (long)input.m_41613_(), (IActionSource)new PlayerSource(player, (IActionHost)this));
                    input.m_41774_((int)inserted);
                }
            }
        });
    }

    public void extractItem(Player player, boolean shift) {
        AEKey aEKey = this.getDisplayed();
        if (!(aEKey instanceof AEItemKey)) {
            return;
        }
        AEItemKey item = (AEItemKey)aEKey;
        if (!this.getMainNode().isActive()) {
            return;
        }
        if (this.getAmount() == 0L && this.canCraft()) {
            CraftAmountMenu.open((ServerPlayer)((ServerPlayer)player), (MenuLocator)MenuLocators.forBlockEntity((BlockEntity)this), (AEKey)item, (int)item.getAmountPerUnit());
            return;
        }
        this.getMainNode().ifPresent(grid -> {
            int count = shift ? 1 : item.getItem().m_41459_();
            long retrieved = StorageHelper.poweredExtraction((IEnergySource)grid.getEnergyService(), (MEStorage)grid.getStorageService().getInventory(), (AEKey)item, (long)count, (IActionSource)new PlayerSource(player, (IActionHost)this));
            if (retrieved != 0L) {
                ItemStack newItems = item.toStack((int)retrieved);
                if (!player.m_150109_().m_36054_(newItems)) {
                    player.m_36176_(newItems, false);
                }
                player.f_36096_.m_38946_();
            }
        });
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        player.m_6915_();
    }

    public ItemStack getMainMenuIcon() {
        return new ItemStack(FullEngBlocks.CONVERSION_MONITOR);
    }
}

