/*
 * Decompiled with CFR 0.152.
 */
package io.github.prismwork.emiffect.util.stack;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import org.jetbrains.annotations.Nullable;

public class StatusEffectEmiStack
extends EmiStack {
    @Nullable
    private final MobEffect effect;

    protected StatusEffectEmiStack(@Nullable MobEffect effect) {
        this.effect = effect;
    }

    public static StatusEffectEmiStack of(@Nullable MobEffect effect) {
        return new StatusEffectEmiStack(effect);
    }

    public EmiStack copy() {
        return StatusEffectEmiStack.of(this.effect);
    }

    public boolean isEmpty() {
        return this.effect == null;
    }

    @Nullable
    public MobEffect getEffect() {
        return this.effect;
    }

    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
        MobEffectTextureManager sprites = Minecraft.m_91087_().m_91306_();
        if (this.effect != null) {
            TextureAtlasSprite sprite = sprites.m_118732_(this.effect);
            RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.m_247685_());
            draw.m_280159_(x, y, 0, 18, 18, sprite);
            RenderSystem.applyModelViewMatrix();
        }
    }

    public CompoundTag getNbt() {
        return null;
    }

    public Object getKey() {
        return this.effect;
    }

    public ResourceLocation getId() {
        return BuiltInRegistries.f_256974_.m_7981_((Object)this.effect);
    }

    public List<Component> getTooltipText() {
        return List.of(this.getName());
    }

    public List<ClientTooltipComponent> getTooltip() {
        if (this.effect == null) {
            return List.of();
        }
        ArrayList<ClientTooltipComponent> tooltips = new ArrayList<ClientTooltipComponent>(this.getTooltipText().stream().map(EmiPort::ordered).map(ClientTooltipComponent::m_169948_).toList());
        switch (this.effect.m_19483_()) {
            case BENEFICIAL: {
                tooltips.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable((String)"tooltip.emiffect.beneficial").m_130940_(ChatFormatting.GREEN))));
                break;
            }
            case NEUTRAL: {
                tooltips.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable((String)"tooltip.emiffect.neutral").m_130940_(ChatFormatting.GOLD))));
                break;
            }
            case HARMFUL: {
                tooltips.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable((String)"tooltip.emiffect.harmful").m_130940_(ChatFormatting.RED))));
            }
        }
        tooltips.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.translatable((String)"tooltip.emiffect.color", (Object[])new Object[]{"#" + String.format("%02x", this.effect.m_19484_())}).m_130940_(ChatFormatting.GRAY))));
        ResourceLocation id = BuiltInRegistries.f_256974_.m_7981_((Object)this.effect);
        if (id != null) {
            tooltips.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.literal((String)EmiUtil.getModName((String)id.m_135827_()), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}))));
        }
        return tooltips;
    }

    public Component getName() {
        return this.effect != null ? this.effect.m_19482_() : EmiPort.literal((String)"missingno");
    }

    public ItemStack getItemStack() {
        ItemStack stack = super.getItemStack();
        if (this.effect != null) {
            stack = PotionUtils.m_43552_((ItemStack)Items.f_42589_.m_7968_(), Collections.singletonList(new MobEffectInstance(this.effect, 600)));
        }
        return stack;
    }
}

