/*
 * Decompiled with CFR 0.152.
 */
package dev.ferriarnus.tinkersjewelry.tools.hooks;

import java.util.Collection;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;

public interface CuriosEquipHook {
    default public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
    }

    default public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
    }

    default public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    default public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    default public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public record AllMerger(Collection<CuriosEquipHook> modules) implements CuriosEquipHook
    {
        @Override
        public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
            for (CuriosEquipHook hook : this.modules) {
                hook.onEquip(slotContext, prevStack, stack);
            }
        }

        @Override
        public void onUnequip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
            for (CuriosEquipHook hook : this.modules) {
                hook.onUnequip(slotContext, prevStack, stack);
            }
        }

        @Override
        public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
            for (CuriosEquipHook hook : this.modules) {
                if (hook.canUnequip(slotContext, stack)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean canEquip(SlotContext slotContext, ItemStack stack) {
            for (CuriosEquipHook hook : this.modules) {
                if (hook.canEquip(slotContext, stack)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
            for (CuriosEquipHook hook : this.modules) {
                if (hook.canEquipFromUse(slotContext, stack)) continue;
                return false;
            }
            return true;
        }
    }
}

