/*
 * Decompiled with CFR 0.152.
 */
package dev.ferriarnus.tinkersjewelry.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.ferriarnus.tinkersjewelry.tools.hooks.AttributeModifierHook;
import dev.ferriarnus.tinkersjewelry.tools.hooks.CuriosEquipHook;
import dev.ferriarnus.tinkersjewelry.tools.hooks.CuriosModifierHooks;
import dev.ferriarnus.tinkersjewelry.tools.hooks.CuriosTickHook;
import dev.ferriarnus.tinkersjewelry.tools.stats.JewelryToolStats;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.TooltipBuilder;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CuriosRingItem
extends ModifiableItem
implements ICurioItem {
    public CuriosRingItem(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties, toolDefinition);
    }

    public List<Component> getStatInformation(IToolStackView tool, @Nullable Player player, List<Component> tooltips, TooltipKey key, TooltipFlag tooltipFlag) {
        List list = super.getStatInformation(tool, player, tooltips, key, tooltipFlag);
        TooltipBuilder builder = new TooltipBuilder(tool, list);
        builder.add((IToolStat)JewelryToolStats.AMPLIFICATION);
        return builder.getTooltips();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        if (tool.isBroken()) {
            return;
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            ((CuriosTickHook)entry.getHook(CuriosModifierHooks.TICK)).curioTick(slotContext, stack, entry);
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        if (tool.isBroken()) {
            return;
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            ((CuriosEquipHook)entry.getHook(CuriosModifierHooks.EQUIP)).onEquip(slotContext, prevStack, stack);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            ((CuriosEquipHook)entry.getHook(CuriosModifierHooks.EQUIP)).onUnequip(slotContext, newStack, stack);
        }
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        if (tool.isBroken()) {
            return true;
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            if (((CuriosEquipHook)entry.getHook(CuriosModifierHooks.EQUIP)).canUnequip(slotContext, stack)) continue;
            return false;
        }
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        if (tool.isBroken()) {
            return false;
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            if (((CuriosEquipHook)entry.getHook(CuriosModifierHooks.EQUIP)).canEquip(slotContext, stack)) continue;
            return false;
        }
        return true;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        if (tool.isBroken()) {
            return false;
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            if (((CuriosEquipHook)entry.getHook(CuriosModifierHooks.EQUIP)).canEquipFromUse(slotContext, stack)) continue;
            return false;
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        HashMultimap multimap = HashMultimap.create();
        if (tool.isBroken()) {
            return multimap;
        }
        if (tool.isBroken()) {
            return multimap;
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            multimap.putAll(((AttributeModifierHook)entry.getHook(CuriosModifierHooks.ATTRIBUTE)).getAttributeModifiers(slotContext, uuid, stack, entry));
        }
        return multimap;
    }

    public List<Component> getSlotsTooltip(List<Component> tooltips, ItemStack stack) {
        return Collections.emptyList();
    }
}

