/*
 * Decompiled with CFR 0.152.
 */
package dev.ferriarnus.tinkersjewelry;

import dev.ferriarnus.tinkersjewelry.tools.hooks.BlockBreakHook;
import dev.ferriarnus.tinkersjewelry.tools.hooks.CuriosModifierHooks;
import dev.ferriarnus.tinkersjewelry.tools.hooks.HurtEnemyHook;
import dev.ferriarnus.tinkersjewelry.tools.hooks.HurtUserHook;
import dev.ferriarnus.tinkersjewelry.tools.modifiers.JewelryModifiers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.logic.ModifierEvents;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DamageItemEvents {
    private static final String SOULBOUND_SLOT = "curios_soulbound";

    @SubscribeEvent
    static void onBlockBreak(BlockEvent.BreakEvent event) {
        CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)event.getPlayer()).ifPresent(curios -> {
            for (int i = 0; i < curios.getSlots(); ++i) {
                ItemStack stackInSlot = curios.getStackInSlot(i);
                if (!(stackInSlot.m_41720_() instanceof ModifiableItem)) continue;
                ToolStack toolStack = ToolStack.from((ItemStack)stackInSlot);
                if (toolStack.isBroken()) {
                    return;
                }
                for (ModifierEntry entry : toolStack.getModifierList()) {
                    ((BlockBreakHook)entry.getHook(CuriosModifierHooks.BLOCK_BREAK)).breakBlock(event.getPlayer(), stackInSlot, event.getPos(), event.getState(), entry);
                }
            }
        });
    }

    @SubscribeEvent
    static void onAttackEntity(LivingAttackEvent event) {
        CuriosApi.getCuriosHelper().getEquippedCurios(event.getEntity()).ifPresent(curios -> {
            for (int i = 0; i < curios.getSlots(); ++i) {
                ItemStack stackInSlot = curios.getStackInSlot(i);
                if (!(stackInSlot.m_41720_() instanceof ModifiableItem)) continue;
                ToolStack toolStack = ToolStack.from((ItemStack)stackInSlot);
                if (toolStack.isBroken()) {
                    return;
                }
                for (ModifierEntry entry : toolStack.getModifierList()) {
                    ((HurtUserHook)entry.getHook(CuriosModifierHooks.HURT_USER_HOOK)).hurtUser(stackInSlot, event.getSource(), event.getAmount(), event.getEntity(), event.getSource().m_7639_(), entry);
                }
            }
        });
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            CuriosApi.getCuriosHelper().getEquippedCurios(entity2).ifPresent(curios -> {
                for (int i = 0; i < curios.getSlots(); ++i) {
                    ItemStack stackInSlot = curios.getStackInSlot(i);
                    if (!(stackInSlot.m_41720_() instanceof ModifiableItem)) continue;
                    ToolStack toolStack = ToolStack.from((ItemStack)stackInSlot);
                    if (toolStack.isBroken()) {
                        return;
                    }
                    for (ModifierEntry entry : toolStack.getModifierList()) {
                        ((HurtEnemyHook)entry.getHook(CuriosModifierHooks.HURT_ENEMY_HOOK)).hurtEnemy(stackInSlot, event.getSource(), event.getAmount(), event.getEntity(), entity2, entry);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    static void onLivingDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) && entity instanceof Player && !((player = (Player)entity) instanceof FakePlayer)) {
            CuriosApi.getCuriosHelper().getEquippedCurios(event.getEntity()).ifPresent(curios -> {
                for (int i = 0; i < curios.getSlots(); ++i) {
                    ItemStack stackInSlot = curios.getStackInSlot(i);
                    if (!ModifierUtil.checkVolatileFlag((ItemStack)stackInSlot, (ResourceLocation)ModifierEvents.SOULBOUND)) continue;
                    stackInSlot.m_41784_().m_128405_(SOULBOUND_SLOT, i);
                }
            });
        }
    }

    @SubscribeEvent
    static void onPlayerDropItems(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        LazyOptional curios = CuriosApi.getCuriosHelper().getEquippedCurios(event.getEntity());
        if (!curios.isPresent()) {
            return;
        }
        if (!entity.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) && entity instanceof Player) {
            Player player = (Player)entity;
            if (!(entity instanceof FakePlayer)) {
                IItemHandlerModifiable iItemHandlerModifiable = (IItemHandlerModifiable)curios.resolve().get();
                Collection drops = event.getDrops();
                Iterator iter = drops.iterator();
                Inventory inventory = player.m_150109_();
                ArrayList<ItemEntity> takenSlot = new ArrayList<ItemEntity>();
                while (iter.hasNext()) {
                    ItemEntity itemEntity = (ItemEntity)iter.next();
                    ItemStack stack = itemEntity.m_32055_();
                    CompoundTag tag = stack.m_41783_();
                    if (tag == null || !tag.m_128425_(SOULBOUND_SLOT, 99)) continue;
                    int slot = tag.m_128451_(SOULBOUND_SLOT);
                    if (iItemHandlerModifiable.getStackInSlot(slot).m_41619_()) {
                        iItemHandlerModifiable.setStackInSlot(slot, stack);
                        tag.m_128473_(SOULBOUND_SLOT);
                    } else {
                        takenSlot.add(itemEntity);
                    }
                    iter.remove();
                }
                for (ItemEntity itemEntity : takenSlot) {
                    ItemStack stack = itemEntity.m_32055_();
                    if (inventory.m_36054_(stack)) continue;
                    CompoundTag tag = stack.m_41783_();
                    if (tag != null) {
                        tag.m_128473_(SOULBOUND_SLOT);
                        if (tag.m_128456_()) {
                            stack.m_41751_(null);
                        }
                    }
                    drops.add(itemEntity);
                }
            }
        }
    }

    @SubscribeEvent
    static void undying(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity.m_21224_()) {
            CuriosApi.getCuriosHelper().getEquippedCurios(entity).ifPresent(curios -> {
                for (int i = 0; i < curios.getSlots(); ++i) {
                    ToolStack tool;
                    ItemStack stackInSlot = curios.getStackInSlot(i);
                    if (!(stackInSlot.m_41720_() instanceof ModifiableItem) || (tool = ToolStack.from((ItemStack)stackInSlot)).isBroken() || tool.getModifierLevel(JewelryModifiers.UNDYING.getId()) <= 0) continue;
                    entity.m_21153_(1.0f);
                    entity.m_21219_();
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
                    ToolDamageUtil.damage((IToolStackView)tool, (int)300, (LivingEntity)entity, (ItemStack)stackInSlot);
                    event.setCanceled(true);
                }
            });
        }
    }
}

