/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.util.json.validator;

import insane96mcp.insanelib.util.json.validator.Validator;

public class DoubleMinMaxValidator
extends Validator<Double> {
    private final double min;
    private final double max;

    public DoubleMinMaxValidator(double min, double max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean test(Double value) {
        return value >= this.min && value <= this.max;
    }

    @Override
    public String getErrorMessage(Double value) {
        return "Value %s must be between %s and %s".formatted(value, this.min, this.max);
    }

    public static DoubleMinMaxValidator between(double min, double max) {
        return new DoubleMinMaxValidator(min, max);
    }

    public static DoubleMinMaxValidator atLeast(double min) {
        return new DoubleMinMaxValidator(min, Double.MAX_VALUE);
    }

    public static DoubleMinMaxValidator atMost(double max) {
        return new DoubleMinMaxValidator(-1.7976931348623157E308, max);
    }
}

