/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.common.util;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import xfacthd.buddingcrystals.common.BCContent;
import xfacthd.buddingcrystals.common.block.BuddingCrystalBlock;
import xfacthd.buddingcrystals.common.item.CrystalBlockItem;
import xfacthd.buddingcrystals.common.util.BudSet;
import xfacthd.buddingcrystals.common.util.CrystalLoader;

public final class CrystalSet {
    private final String compatMod;
    private final String name;
    private String translation;
    private ResourceLocation crystalTexture;
    private ResourceLocation buddingTexture;
    private final int growthChance;
    private final RegistryObject<Block> buddingBlock;
    private final BudSet budSet;
    private RegistryObject<Item> drop;
    private RegistryObject<Item> ingredient;
    private float normalDrop;
    private float maxDrop;

    CrystalSet(String compatMod, String name, String translation, ResourceLocation crystalTexture, ResourceLocation buddingTexture, int growthChance, RegistryObject<Block> buddingBlock, BudSet budSet, RegistryObject<Item> drop, RegistryObject<Item> ingredient, float normalDrop, float maxDrop) {
        this.compatMod = compatMod;
        this.name = name;
        this.translation = translation;
        this.crystalTexture = crystalTexture;
        this.buddingTexture = buddingTexture;
        this.growthChance = growthChance;
        this.buddingBlock = buddingBlock;
        this.budSet = budSet;
        this.drop = drop;
        this.ingredient = ingredient;
        this.normalDrop = normalDrop;
        this.maxDrop = maxDrop;
    }

    public String getName() {
        return this.name;
    }

    public String getTranslation() {
        return this.translation;
    }

    public ResourceLocation getCrystalSourceTexture() {
        return this.crystalTexture;
    }

    public ResourceLocation getBuddingSourceTexture() {
        return this.buddingTexture;
    }

    public int getGrowthChance() {
        return this.growthChance;
    }

    public Block getBuddingBlock() {
        return (Block)this.buddingBlock.get();
    }

    public Block getSmallBud() {
        return (Block)this.budSet.smallBud.get();
    }

    public Block getMediumBud() {
        return (Block)this.budSet.mediumBud.get();
    }

    public Block getLargeBud() {
        return (Block)this.budSet.largeBud.get();
    }

    public Block getCluster() {
        return (Block)this.budSet.cluster.get();
    }

    public BudSet getBudSet() {
        return this.budSet;
    }

    public Item getDroppedItem() {
        return (Item)this.drop.orElse((Object)Items.f_41852_);
    }

    public Item getIngredient() {
        return (Item)this.ingredient.orElse((Object)Items.f_41852_);
    }

    public float getNormalDrops() {
        return this.normalDrop;
    }

    public float getMaxDrops() {
        return this.maxDrop;
    }

    public List<Block> blocks() {
        return List.of((Block)this.buddingBlock.get(), (Block)this.budSet.smallBud.get(), (Block)this.budSet.mediumBud.get(), (Block)this.budSet.largeBud.get(), (Block)this.budSet.cluster.get());
    }

    public String getCompatMod() {
        return this.compatMod;
    }

    public boolean isActive() {
        return ModList.get().isLoaded(this.compatMod);
    }

    public String getConfigString() {
        return "enable_crafting_budding_" + this.getName();
    }

    public String getConfigTranslation() {
        return "config.buddingcrystals." + this.getConfigString();
    }

    public void updateClientData(String translation, ResourceLocation crystalTexture, ResourceLocation buddingTexture) {
        this.translation = translation;
        this.crystalTexture = crystalTexture;
        this.buddingTexture = buddingTexture;
    }

    public void updateServerData(ResourceLocation dropName, ResourceLocation ingredientName, float normalDrop, float maxDrop) {
        this.drop = RegistryObject.create((ResourceLocation)dropName, (IForgeRegistry)ForgeRegistries.ITEMS);
        this.ingredient = this.drop;
        if (!dropName.equals((Object)ingredientName)) {
            this.ingredient = RegistryObject.create((ResourceLocation)ingredientName, (IForgeRegistry)ForgeRegistries.ITEMS);
        }
        this.normalDrop = normalDrop;
        this.maxDrop = maxDrop;
        this.validate();
    }

    public void validate() {
        if (!this.drop.isPresent()) {
            CrystalLoader.LOGGER.error("CrystalSet '{}' references an invalid item, it will be not drop anything!", (Object)this.name);
        }
        if (!this.ingredient.isPresent()) {
            CrystalLoader.LOGGER.error("CrystalSet '{}' references an invalid item, it will be not be craftable!", (Object)this.name);
        }
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static CrystalSet builtinAmethyst() {
        BudSet budSet = new BudSet((RegistryObject<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("small_amethyst_bud"), (IForgeRegistry)ForgeRegistries.BLOCKS), (RegistryObject<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("medium_amethyst_bud"), (IForgeRegistry)ForgeRegistries.BLOCKS), (RegistryObject<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("large_amethyst_bud"), (IForgeRegistry)ForgeRegistries.BLOCKS), (RegistryObject<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("amethyst_cluster"), (IForgeRegistry)ForgeRegistries.BLOCKS));
        RegistryObject drop = RegistryObject.create((ResourceLocation)new ResourceLocation("amethyst_shard"), (IForgeRegistry)ForgeRegistries.ITEMS);
        return new CrystalSet("minecraft", "amethyst", "Amethyst", new ResourceLocation("minecraft:item/amethyst_shard"), new ResourceLocation("minecraft:item/amethyst_shard"), 5, (RegistryObject<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation("budding_amethyst"), (IForgeRegistry)ForgeRegistries.BLOCKS), budSet, (RegistryObject<Item>)drop, (RegistryObject<Item>)drop, 2.0f, 4.0f);
    }

    public static final class Builder {
        private final String name;
        private String translation;
        private String compatMod = "minecraft";
        private String crystalTexPath;
        private String buddingTexPath;
        private ResourceLocation crystalTexture;
        private ResourceLocation buddingTexture;
        private int growthChance = 5;
        private RegistryObject<Item> drop;
        private RegistryObject<Item> ingredient;
        private float normalDrop = 2.0f;
        private float maxDrop = 4.0f;

        private Builder(String name) {
            Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0, (Object)"Name must not be empty");
            this.name = name;
        }

        public Builder translation(String translation) {
            Preconditions.checkArgument((translation != null && !translation.isEmpty() ? 1 : 0) != 0, (Object)"Translation must not be empty");
            this.translation = translation;
            return this;
        }

        public Builder compatMod(String compatMod) {
            Preconditions.checkArgument((compatMod != null && !compatMod.isEmpty() ? 1 : 0) != 0, (Object)"Compat mod must not be empty");
            this.compatMod = compatMod;
            return this;
        }

        public Builder sourceTexture(String texture) {
            Preconditions.checkArgument((texture != null && !texture.isEmpty() ? 1 : 0) != 0, (Object)"Texture must not be empty");
            this.crystalTexPath = texture;
            this.buddingTexPath = texture;
            return this;
        }

        public Builder buddingSourceTexture(String texture) {
            Preconditions.checkArgument((texture != null && !texture.isEmpty() ? 1 : 0) != 0, (Object)"Budding texture must not be empty");
            this.buddingTexPath = texture;
            return this;
        }

        public Builder crystalSourceTexture(String texture) {
            Preconditions.checkArgument((texture != null && !texture.isEmpty() ? 1 : 0) != 0, (Object)"Crystal texture must not be empty");
            this.crystalTexPath = texture;
            return this;
        }

        public Builder sourceTexture(ResourceLocation texture) {
            Preconditions.checkArgument((texture != null ? 1 : 0) != 0, (Object)"Texture must not be null");
            this.buddingTexture = texture;
            this.crystalTexture = texture;
            return this;
        }

        public Builder buddingSourceTexture(ResourceLocation texture) {
            Preconditions.checkArgument((texture != null ? 1 : 0) != 0, (Object)"Budding texture must not be null");
            this.buddingTexture = texture;
            return this;
        }

        public Builder crystalSourceTexture(ResourceLocation texture) {
            Preconditions.checkArgument((texture != null ? 1 : 0) != 0, (Object)"Crystal texture must not be null");
            this.crystalTexture = texture;
            return this;
        }

        public Builder growthChance(int chance) {
            Preconditions.checkArgument((chance > 0 ? 1 : 0) != 0, (Object)"Growth chance must be higher than 0");
            this.growthChance = chance;
            return this;
        }

        public Builder drop(String drop) {
            Preconditions.checkArgument((drop != null && !drop.isEmpty() ? 1 : 0) != 0, (Object)"Dropped item must not be empty");
            return this.drop(new ResourceLocation(drop));
        }

        public Builder drop(ResourceLocation drop) {
            Preconditions.checkArgument((drop != null ? 1 : 0) != 0, (Object)"Dropped item must not be null");
            this.drop = RegistryObject.create((ResourceLocation)drop, (IForgeRegistry)ForgeRegistries.ITEMS);
            return this;
        }

        public Builder ingredient(String ingredient) {
            Preconditions.checkArgument((ingredient != null && !ingredient.isEmpty() ? 1 : 0) != 0, (Object)"Ingredient item must not be empty");
            return this.ingredient(new ResourceLocation(ingredient));
        }

        public Builder ingredient(ResourceLocation ingredient) {
            Preconditions.checkArgument((ingredient != null ? 1 : 0) != 0, (Object)"Ingredient item must not be null");
            this.ingredient = RegistryObject.create((ResourceLocation)ingredient, (IForgeRegistry)ForgeRegistries.ITEMS);
            return this;
        }

        public Builder normalDrop(float count) {
            Preconditions.checkArgument((count > 0.0f ? 1 : 0) != 0, (Object)"Normal drop count must be higher than 0");
            this.normalDrop = count;
            return this;
        }

        public Builder maxDrop(float count) {
            Preconditions.checkArgument((count > 0.0f ? 1 : 0) != 0, (Object)"Max drop count must be higher than 0");
            this.maxDrop = count;
            return this;
        }

        public CrystalSet build() {
            CrystalLoader.overrideFromJson(this.name, this);
            Preconditions.checkState((this.translation != null ? 1 : 0) != 0, (Object)"No translation set");
            Preconditions.checkState((this.crystalTexPath != null || this.crystalTexture != null ? 1 : 0) != 0, (Object)"No crystal source texture set");
            Preconditions.checkState((this.buddingTexPath != null || this.buddingTexture != null ? 1 : 0) != 0, (Object)"No budding block source texture set");
            Preconditions.checkState((this.drop != null ? 1 : 0) != 0, (Object)"No dropped item specified");
            Preconditions.checkState((this.maxDrop >= this.normalDrop ? 1 : 0) != 0, (Object)"Max drop must be higher or equal to normal drop");
            RegistryObject<Block> smallBud = Builder.register("small_" + this.name + "_bud", Builder::smallBud, this.compatMod);
            RegistryObject<Block> mediumBud = Builder.register("medium_" + this.name + "_bud", Builder::mediumBud, this.compatMod);
            RegistryObject<Block> largeBud = Builder.register("large_" + this.name + "_bud", Builder::largeBud, this.compatMod);
            RegistryObject<Block> cluster = Builder.register(this.name + "_cluster", Builder::cluster, this.compatMod);
            BudSet budSet = new BudSet(smallBud, mediumBud, largeBud, cluster);
            RegistryObject<Block> buddingBlock = Builder.register("budding_" + this.name, () -> new BuddingCrystalBlock(budSet, this.growthChance, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_278166_(PushReaction.DESTROY).m_60977_().m_60978_(1.5f).m_60918_(SoundType.f_154654_).m_60999_()), this.compatMod);
            if (this.crystalTexture == null) {
                this.crystalTexture = new ResourceLocation(this.compatMod, this.crystalTexPath);
            }
            if (this.buddingTexture == null) {
                this.buddingTexture = new ResourceLocation(this.compatMod, this.buddingTexPath);
            }
            CrystalSet set = new CrystalSet(this.compatMod, this.name, this.translation, this.crystalTexture, this.buddingTexture, this.growthChance, buddingBlock, budSet, this.drop, this.ingredient == null ? this.drop : this.ingredient, this.normalDrop, this.maxDrop);
            BCContent.ALL_SETS.put(this.name, set);
            BCContent.BUILTIN_SETS.put(this.name, set);
            return set;
        }

        static AmethystClusterBlock smallBud() {
            return Builder.cluster(SoundType.f_154656_, 1, 3, 4);
        }

        static AmethystClusterBlock mediumBud() {
            return Builder.cluster(SoundType.f_154656_, 2, 4, 3);
        }

        static AmethystClusterBlock largeBud() {
            return Builder.cluster(SoundType.f_154656_, 4, 5, 3);
        }

        static AmethystClusterBlock cluster() {
            return Builder.cluster(SoundType.f_154655_, 5, 7, 3);
        }

        static AmethystClusterBlock cluster(SoundType sound, int light, int height, int widthShrink) {
            BlockBehaviour.Properties props = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_280606_().m_278166_(PushReaction.DESTROY).m_60955_().m_60977_().m_60918_(sound).m_60978_(1.5f).m_60953_(state -> light);
            return new AmethystClusterBlock(height, widthShrink, props);
        }

        static RegistryObject<Block> register(String name, Supplier<Block> blockFactory, String compatMod) {
            RegistryObject block = BCContent.BLOCKS.register(name, blockFactory);
            BCContent.ITEMS.register(name, () -> new CrystalBlockItem((Block)block.get(), compatMod));
            return block;
        }
    }
}

