/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.common.util;

import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;
import xfacthd.buddingcrystals.common.BCContent;
import xfacthd.buddingcrystals.common.block.BuddingCrystalBlock;
import xfacthd.buddingcrystals.common.data.BCCodecs;
import xfacthd.buddingcrystals.common.util.BudSet;
import xfacthd.buddingcrystals.common.util.CrystalSet;

public final class CrystalLoader {
    private static final Pattern VALID_NAME = Pattern.compile("^[a-z][a-z\\d_]+$");
    public static final Path CRYSTAL_PATH = FMLPaths.GAMEDIR.get().resolve("buddingcrystals");
    static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Codec<CrystalDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_263723_.optionalFieldOf("compat_mod", (Object)"minecraft").forGetter(CrystalDefinition::compatMod), (App)ExtraCodecs.f_263723_.fieldOf("translation").forGetter(CrystalDefinition::translation), (App)Codec.either((Codec)Codec.pair((Codec)ResourceLocation.f_135803_.fieldOf("crystal_texture").codec(), (Codec)ResourceLocation.f_135803_.fieldOf("budding_texture").codec()), (Codec)ResourceLocation.f_135803_).fieldOf("texture").forGetter(CrystalDefinition::eitherTexture), (App)BCCodecs.intMin(0).fieldOf("growth_chance").forGetter(CrystalDefinition::growthChance), (App)ResourceLocation.f_135803_.fieldOf("dropped_item").forGetter(CrystalDefinition::dropName), (App)ResourceLocation.f_135803_.optionalFieldOf("recipe_item").forGetter(CrystalDefinition::recipeName), (App)BCCodecs.floatMin(0.0f).fieldOf("normal_drop_chance").forGetter(CrystalDefinition::normalDrop), (App)BCCodecs.floatMin(0.0f).fieldOf("max_drop_chance").forGetter(CrystalDefinition::maxDrop)).apply((Applicative)instance, CrystalDefinition::new));

    public static void loadUserSets() {
        LOGGER.info("Loading custom crystal definitions");
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Files.createDirectories(CRYSTAL_PATH, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create crystal definitions directory", e);
        }
        try (Stream<Path> paths = Files.list(CRYSTAL_PATH);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(filePath -> filePath.toString().endsWith(".json")).filter(CrystalLoader::filterBuiltins).forEach(filePath -> {
                String name = CrystalLoader.getName(filePath);
                if (!VALID_NAME.matcher(name).matches()) {
                    LOGGER.error("Invalid crystal definition name {}, does not match pattern {} ", (Object)name, (Object)VALID_NAME.pattern());
                    return;
                }
                try {
                    JsonObject json = CrystalLoader.readJsonFile(filePath);
                    CrystalLoader.loadDefinition(name, json);
                }
                catch (JsonParseException e) {
                    LOGGER.error("Encountered an error while loading crystal definition for '" + name + "'", (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Encountered an error while loading crystal definitions", (Throwable)e);
        }
        stopwatch.stop();
        LOGGER.info("Crystal definitions loaded in {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public static void overrideFromJson(String name, CrystalSet.Builder builder) {
        Path file = CRYSTAL_PATH.resolve(name + ".json");
        if (Files.exists(file, new LinkOption[0])) {
            CrystalDefinition def;
            try {
                JsonObject json = CrystalLoader.readJsonFile(file);
                def = CrystalLoader.parseJson(json);
            }
            catch (JsonParseException e) {
                LOGGER.error("Encountered an error while loading override for builtin CrystalSet '" + name + "'", (Throwable)e);
                return;
            }
            builder.translation(def.translation).compatMod(def.compatMod).buddingSourceTexture(def.buddingTexture).crystalSourceTexture(def.crystalTexture).growthChance(def.growthChance).ingredient(def.ingredientName).drop(def.dropName).normalDrop(def.normalDrop).maxDrop(def.maxDrop);
        }
    }

    public static void updateFromJson(Update type) {
        BCContent.allSets().forEach(set -> {
            Path filePath = CRYSTAL_PATH.resolve(set.getName() + ".json");
            if (!Files.exists(filePath, new LinkOption[0])) {
                if (!BCContent.builtinSets().contains(set)) {
                    LOGGER.error("Crystal definition for '{}' went missing after startup!", (Object)set.getName());
                }
                return;
            }
            try {
                JsonObject json = CrystalLoader.readJsonFile(filePath);
                CrystalDefinition def = CrystalLoader.parseJson(json);
                if (type == Update.SERVER) {
                    set.updateServerData(def.dropName, def.ingredientName, def.normalDrop, def.maxDrop);
                } else {
                    set.updateClientData(def.translation, def.crystalTexture, def.buddingTexture);
                }
            }
            catch (JsonParseException e) {
                LOGGER.error("Encountered an error while updating crystal definition for '" + set.getName() + "'", (Throwable)e);
            }
        });
    }

    public static String export(String name) {
        CrystalSet set = BCContent.BUILTIN_SETS.get(name);
        CrystalDefinition def = CrystalDefinition.fromSet(set);
        JsonElement json = (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)def).result().orElseThrow();
        return GSON.toJson(json);
    }

    private static JsonObject readJsonFile(Path path) {
        JsonObject jsonObject;
        block8: {
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JsonSyntaxException((Throwable)e);
                }
            }
            ((Reader)reader).close();
        }
        return jsonObject;
    }

    private static void loadDefinition(String name, JsonObject json) {
        RegistryObject drop;
        CrystalDefinition def = CrystalLoader.parseJson(json);
        RegistryObject ingredient = drop = RegistryObject.create((ResourceLocation)def.dropName, (IForgeRegistry)ForgeRegistries.ITEMS);
        if (!def.dropName.equals((Object)def.ingredientName)) {
            ingredient = RegistryObject.create((ResourceLocation)def.ingredientName, (IForgeRegistry)ForgeRegistries.ITEMS);
        }
        RegistryObject<Block> smallBud = CrystalSet.Builder.register("small_" + name + "_bud", CrystalSet.Builder::smallBud, def.compatMod);
        RegistryObject<Block> mediumBud = CrystalSet.Builder.register("medium_" + name + "_bud", CrystalSet.Builder::mediumBud, def.compatMod);
        RegistryObject<Block> largeBud = CrystalSet.Builder.register("large_" + name + "_bud", CrystalSet.Builder::largeBud, def.compatMod);
        RegistryObject<Block> cluster = CrystalSet.Builder.register(name + "_cluster", CrystalSet.Builder::cluster, def.compatMod);
        BudSet budSet = new BudSet(smallBud, mediumBud, largeBud, cluster);
        RegistryObject<Block> buddingBlock = CrystalSet.Builder.register("budding_" + name, () -> new BuddingCrystalBlock(budSet, def.growthChance, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_278166_(PushReaction.DESTROY).m_60977_().m_60978_(1.5f).m_60918_(SoundType.f_154654_).m_60999_()), def.compatMod);
        CrystalSet set = new CrystalSet(def.compatMod, name, def.translation, def.crystalTexture, def.buddingTexture, def.growthChance, buddingBlock, budSet, (RegistryObject<Item>)drop, (RegistryObject<Item>)ingredient, def.normalDrop, def.maxDrop);
        BCContent.ALL_SETS.put(name, set);
        BCContent.LOADED_SETS.put(name, set);
    }

    private static CrystalDefinition parseJson(JsonObject json) {
        DataResult result = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
        if (result.error().isPresent()) {
            throw new JsonParseException(((DataResult.PartialResult)result.error().get()).message());
        }
        return (CrystalDefinition)result.result().orElseThrow();
    }

    private static String getName(Path path) {
        String file = path.getFileName().toString();
        return file.substring(0, file.indexOf(46));
    }

    private static boolean filterBuiltins(Path path) {
        String name = CrystalLoader.getName(path);
        return !name.equals("amethyst") && !BCContent.BUILTIN_SETS.containsKey(name);
    }

    private CrystalLoader() {
    }

    private record CrystalDefinition(String compatMod, String translation, ResourceLocation crystalTexture, ResourceLocation buddingTexture, int growthChance, ResourceLocation ingredientName, ResourceLocation dropName, float normalDrop, float maxDrop) {
        public CrystalDefinition(String compatMod, String translation, Either<Pair<ResourceLocation, ResourceLocation>, ResourceLocation> texture, int growthChance, ResourceLocation dropName, Optional<ResourceLocation> ingredientName, float normalDrop, float maxDrop) {
            this(compatMod, translation, CrystalDefinition.either(texture, Pair::getFirst), CrystalDefinition.either(texture, Pair::getSecond), growthChance, dropName, ingredientName.orElse(dropName), normalDrop, maxDrop);
        }

        public Either<Pair<ResourceLocation, ResourceLocation>, ResourceLocation> eitherTexture() {
            if (this.crystalTexture.equals((Object)this.buddingTexture)) {
                return Either.right((Object)this.crystalTexture);
            }
            return Either.left((Object)Pair.of((Object)this.crystalTexture, (Object)this.buddingTexture));
        }

        public Optional<ResourceLocation> recipeName() {
            return Optional.of(this.ingredientName);
        }

        private static ResourceLocation either(Either<Pair<ResourceLocation, ResourceLocation>, ResourceLocation> texture, Function<Pair<ResourceLocation, ResourceLocation>, ResourceLocation> pairMapper) {
            return texture.mapLeft(pairMapper).left().orElseGet(texture.right()::orElseThrow);
        }

        public static CrystalDefinition fromSet(CrystalSet set) {
            return new CrystalDefinition(set.getCompatMod(), set.getTranslation(), set.getCrystalSourceTexture(), set.getBuddingSourceTexture(), set.getGrowthChance(), ForgeRegistries.ITEMS.getKey((Object)set.getIngredient()), ForgeRegistries.ITEMS.getKey((Object)set.getDroppedItem()), set.getNormalDrops(), set.getMaxDrops());
        }
    }

    public static enum Update {
        SERVER,
        CLIENT;


        public static Update fromPackType(PackType type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case PackType.CLIENT_RESOURCES -> CLIENT;
                case PackType.SERVER_DATA -> SERVER;
            };
        }
    }
}

