/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.common.dynpack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.BlockTagsProvider;
import org.slf4j.Logger;
import xfacthd.buddingcrystals.common.BCContent;
import xfacthd.buddingcrystals.common.dynpack.DummyPackOutput;

public final class DynamicTagGenerator
extends BlockTagsProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<ResourceLocation, String> cache;

    DynamicTagGenerator(Map<ResourceLocation, String> cache, CompletableFuture<HolderLookup.Provider> holderProvider) {
        super((PackOutput)DummyPackOutput.INSTANCE, holderProvider, "buddingcrystals", null);
        this.cache = cache;
    }

    protected void m_6577_(HolderLookup.Provider provider) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender crystalSoundBlocks = this.m_206424_(BlockTags.f_144270_);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender buddingBlocks = this.m_206424_(BCContent.BUDDING_BLOCKS_TAG);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender pickaxeMineable = this.m_206424_(BlockTags.f_144282_);
        BCContent.loadedSets().forEach(set -> {
            crystalSoundBlocks.m_255245_((Object)set.getBuddingBlock());
            buddingBlocks.m_255245_((Object)set.getBuddingBlock());
            pickaxeMineable.m_255179_((Object[])((Block[])set.blocks().toArray(Block[]::new)));
        });
    }

    protected TagBuilder m_236451_(TagKey<Block> tag) {
        return this.f_126543_.computeIfAbsent(tag.f_203868_(), loc -> new TagBuilder());
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.f_126543_.clear();
        this.m_6577_((HolderLookup.Provider)this.m_274574_().join());
        this.f_126543_.forEach((loc, tag) -> {
            ResourceLocation path = new ResourceLocation(loc.m_135827_(), TagManager.m_203918_((ResourceKey)this.f_254716_) + "/" + loc.m_135815_() + ".json");
            String tagJson = GSON.toJson((JsonElement)TagFile.f_215958_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TagFile(tag.m_215904_(), false)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
            this.cache.put(path, tagJson);
        });
        return CompletableFuture.completedFuture(null);
    }

    public String m_6055_() {
        return "dynamic_tags";
    }
}

