/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.common.dynpack;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import xfacthd.buddingcrystals.common.BCContent;
import xfacthd.buddingcrystals.common.data.OptionalLootItem;
import xfacthd.buddingcrystals.common.util.CrystalSet;

final class DynamicBlockLoot
extends BlockLootSubProvider {
    private static final FeatureFlagSet ENABLED_FEATURES = FeatureFlags.f_244377_;

    public DynamicBlockLoot() {
        super(Set.of(), ENABLED_FEATURES);
    }

    public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
    }

    public void run(Map<ResourceLocation, String> cache) {
        this.m_245660_();
        Map tables = (Map)ObfuscationReflectionHelper.getPrivateValue(BlockLootSubProvider.class, (Object)((Object)this), (String)"f_244441_");
        HashMap<ResourceLocation, LootTable> built = new HashMap<ResourceLocation, LootTable>();
        Objects.requireNonNull(tables).forEach((loc, builder) -> {
            if (!built.containsKey(loc)) {
                LootTable table = builder.m_287223_(loc).m_79165_(LootContextParamSets.f_81421_).m_79167_();
                built.put((ResourceLocation)loc, table);
            }
        });
        built.forEach((loc, table) -> cache.put(new ResourceLocation(loc.m_135827_(), "loot_tables/" + loc.m_135815_() + ".json"), LootDataType.f_278413_.m_278857_().toJsonTree(table).toString()));
    }

    protected Iterable<Block> getKnownBlocks() {
        return BCContent.loadedSets().stream().map(CrystalSet::blocks).flatMap(Collection::stream).toList();
    }

    protected void m_245660_() {
        BCContent.loadedSets().forEach(set -> {
            this.m_247577_(set.getBuddingBlock(), DynamicBlockLoot.m_246386_());
            this.m_245644_(set.getSmallBud());
            this.m_245644_(set.getMediumBud());
            this.m_245644_(set.getLargeBud());
            this.m_246481_(set.getCluster(), block -> DynamicBlockLoot.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)OptionalLootItem.lootTableItem((ItemLike)set.getDroppedItem()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)set.getMaxDrops()))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(ItemTags.f_144323_)))).m_7170_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)OptionalLootItem.lootTableItem((ItemLike)set.getDroppedItem()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)set.getNormalDrops())))))));
        });
    }
}

