/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.common.dynpack;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import org.slf4j.Logger;
import xfacthd.buddingcrystals.common.util.CrystalLoader;

public abstract class BuddingPackResources
implements PackResources {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private final PackMetadataSection packMetadata;
    private final Map<ResourceLocation, String> dataCache = new ConcurrentHashMap<ResourceLocation, String>();
    private final PackType type;
    private final Set<String> namespaces;

    protected BuddingPackResources(PackType type, int packFormat) {
        this.type = type;
        this.packMetadata = new PackMetadataSection((Component)Component.m_237113_((String)this.m_5542_()), packFormat);
        String typeName = type == PackType.CLIENT_RESOURCES ? "resourcepack" : "datapack";
        LOGGER.info("Reloading crystal definitions for dynamic {} reload", (Object)typeName);
        Stopwatch stopwatch = Stopwatch.createStarted();
        CrystalLoader.updateFromJson(CrystalLoader.Update.fromPackType(type));
        stopwatch.stop();
        LOGGER.info("Reloaded crystal definitions in {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        LOGGER.info("Generating dynamic {} for BuddingCrystals", (Object)typeName);
        stopwatch = Stopwatch.createStarted();
        this.buildResources(this.dataCache);
        this.namespaces = this.dataCache.keySet().stream().map(ResourceLocation::m_135827_).collect(Collectors.toSet());
        stopwatch.stop();
        LOGGER.info("Generated dynamic {} in {}ms", (Object)typeName, (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public IoSupplier<InputStream> m_8017_(String ... fileName) {
        return null;
    }

    public final IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
        if (type == this.type && this.dataCache.containsKey(location)) {
            return this.supplierForPath(location);
        }
        return null;
    }

    public void m_8031_(PackType type, String namespace, String path, PackResources.ResourceOutput output) {
        if (type == this.type) {
            this.dataCache.keySet().stream().filter(loc -> loc.m_135827_().equals(namespace)).filter(loc -> loc.m_135815_().startsWith(path)).forEach(loc -> output.accept(loc, this.supplierForPath((ResourceLocation)loc)));
        }
    }

    private IoSupplier<InputStream> supplierForPath(ResourceLocation loc) {
        return () -> new ByteArrayInputStream(this.dataCache.get(loc).getBytes(StandardCharsets.UTF_8));
    }

    public final Set<String> m_5698_(PackType type) {
        return type == this.type ? this.namespaces : Set.of();
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) {
        if (deserializer == PackMetadataSection.f_243696_) {
            return (T)this.packMetadata;
        }
        return null;
    }

    public void close() {
    }

    public final boolean isHidden() {
        return true;
    }

    protected abstract void buildResources(Map<ResourceLocation, String> var1);

    protected static ResourceLocation mcRl(String path) {
        return new ResourceLocation("minecraft", path);
    }

    protected static ResourceLocation bcRl(String path) {
        return new ResourceLocation("buddingcrystals", path);
    }
}

