/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.common.datagen.providers;

import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import xfacthd.buddingcrystals.common.BCContent;
import xfacthd.buddingcrystals.common.util.CrystalSet;

public final class BuddingStateProvider
extends BlockStateProvider {
    public BuddingStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "buddingcrystals", exFileHelper);
    }

    protected void registerStatesAndModels() {
        BCContent.builtinSets().forEach(set -> BuddingStateProvider.makeModels(this, set));
    }

    public static void makeModels(BlockStateProvider provider, CrystalSet set) {
        BuddingStateProvider.cluster(provider, set.getSmallBud(), "item/small_amethyst_bud", BuddingStateProvider.rl("block/small_bud/" + set.getName()));
        BuddingStateProvider.cluster(provider, set.getMediumBud(), "item/medium_amethyst_bud", BuddingStateProvider.rl("block/medium_bud/" + set.getName()));
        BuddingStateProvider.cluster(provider, set.getLargeBud(), "item/large_amethyst_bud", BuddingStateProvider.rl("block/large_bud/" + set.getName()));
        BuddingStateProvider.cluster(provider, set.getCluster(), "item/amethyst_cluster", BuddingStateProvider.rl("block/cluster/" + set.getName()));
        BuddingStateProvider.buddingBlock(provider, set.getBuddingBlock(), set.getName());
    }

    private static void cluster(BlockStateProvider provider, Block block, String itemParent, ResourceLocation texture) {
        String name = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent(name, provider.modLoc("block/cross"))).texture("cross", texture)).renderType("cutout");
        provider.getVariantBuilder(block).forAllStatesExcept(arg_0 -> BuddingStateProvider.lambda$cluster$1((ModelFile)model, arg_0), new Property[]{AmethystClusterBlock.f_152005_});
        ((ItemModelBuilder)provider.itemModels().withExistingParent(name, itemParent)).texture("layer0", texture);
    }

    private static void buddingBlock(BlockStateProvider provider, Block block, String name) {
        String path = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        provider.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent(path, provider.modLoc("block/cube_all"))).texture("all", BuddingStateProvider.rl("block/budding/" + name))).renderType("solid"));
        provider.itemModels().withExistingParent(path, provider.modLoc("block/" + path));
    }

    private static ResourceLocation rl(String path) {
        return new ResourceLocation("buddingcrystals", path);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$cluster$1(ModelFile model, BlockState state) {
        int rotX;
        return ConfiguredModel.builder().modelFile(model).rotationX(rotX).rotationY(switch ((Direction)state.m_61143_((Property)AmethystClusterBlock.f_152006_)) {
            case Direction.UP -> {
                rotX = 0;
                yield 0;
            }
            case Direction.DOWN -> {
                rotX = 180;
                yield 0;
            }
            case Direction.NORTH -> {
                rotX = 90;
                yield 0;
            }
            case Direction.EAST -> {
                rotX = 90;
                yield 90;
            }
            case Direction.SOUTH -> {
                rotX = 90;
                yield 180;
            }
            case Direction.WEST -> {
                rotX = 90;
                yield 270;
            }
            default -> throw new IllegalArgumentException("Invalid direction");
        }).build();
    }
}

