/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.common.datagen.providers;

import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.LanguageProvider;
import xfacthd.buddingcrystals.common.BCContent;
import xfacthd.buddingcrystals.common.util.CrystalSet;
import xfacthd.buddingcrystals.common.util.CrystalTab;

public final class BuddingLanguageProvider
extends LanguageProvider {
    public BuddingLanguageProvider(PackOutput output) {
        super(output, "buddingcrystals", "en_us");
    }

    protected void addTranslations() {
        this.add(CrystalTab.TAB_TITLE.getString(), "BuddingCrystals");
        this.add(BCContent.AMETHYST.getConfigTranslation(), "Allow crafting of budding Amethyst block");
        BCContent.builtinSets().forEach(set -> {
            this.translate((CrystalSet)set, set.getTranslation());
            this.add(set.getConfigTranslation(), "Allow crafting of budding " + set.getTranslation() + " block");
        });
        this.add((Item)BCContent.CRYSTAL_CATALYST.get(), "Crystal Catalyst");
        this.add("commands.buddingcrystals.no_such_crystal", "No crystal named '%s' exists");
        this.add("commands.buddingcrystals.export_error", "Encountered an error while exporting crystal definition named '%s': %s");
        this.add("commands.buddingcrystals.crystals_exported", "Exported %d out of %d builtin crystal definitions, skipped %d existing files");
        this.add("commands.buddingcrystals.crystals_overwritten", "Exported %d out of %d builtin crystal definitions, %d existing files were overwritten");
        this.add("commands.buddingcrystals.crystal_exported", "Exported crystal definition named '%s'");
        this.add("commands.buddingcrystals.crystal_overwritten", "Exported crystal definition named '%s', existing file was overwritten");
        this.add("commands.buddingcrystals.crystal_exists", "File for crystal definition named '%s' already exists");
    }

    private void translate(CrystalSet set, String name) {
        this.add(set.getSmallBud(), "Small " + name + " Bud");
        this.add(set.getMediumBud(), "Medium " + name + " Bud");
        this.add(set.getLargeBud(), "Large " + name + " Bud");
        this.add(set.getCluster(), name + " Cluster");
        this.add(set.getBuddingBlock(), "Budding " + name);
    }
}

