/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.common.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xfacthd.buddingcrystals.common.BCContent;
import xfacthd.buddingcrystals.common.datagen.providers.BuddingBlockTagsProvider;
import xfacthd.buddingcrystals.common.datagen.providers.BuddingItemModelProvider;
import xfacthd.buddingcrystals.common.datagen.providers.BuddingLanguageProvider;
import xfacthd.buddingcrystals.common.datagen.providers.BuddingLootTableProvider;
import xfacthd.buddingcrystals.common.datagen.providers.BuddingRecipeProvider;
import xfacthd.buddingcrystals.common.datagen.providers.BuddingStateProvider;

@Mod.EventBusSubscriber(modid="buddingcrystals", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class GeneratorHandler {
    private static final ExistingFileHelper.ResourceType TEXTURE_TYPE = new ExistingFileHelper.ResourceType(PackType.CLIENT_RESOURCES, ".png", "textures");

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture holderProvider = event.getLookupProvider();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        fileHelper.trackGenerated(GeneratorHandler.bcRl("item/crystal_catalyst"), (ExistingFileHelper.IResourceType)TEXTURE_TYPE);
        BCContent.builtinSets().forEach(set -> {
            String name = set.getName();
            fileHelper.trackGenerated(GeneratorHandler.bcRl("block/budding/" + name), (ExistingFileHelper.IResourceType)TEXTURE_TYPE);
            fileHelper.trackGenerated(GeneratorHandler.bcRl("block/small_bud/" + name), (ExistingFileHelper.IResourceType)TEXTURE_TYPE);
            fileHelper.trackGenerated(GeneratorHandler.bcRl("block/medium_bud/" + name), (ExistingFileHelper.IResourceType)TEXTURE_TYPE);
            fileHelper.trackGenerated(GeneratorHandler.bcRl("block/large_bud/" + name), (ExistingFileHelper.IResourceType)TEXTURE_TYPE);
            fileHelper.trackGenerated(GeneratorHandler.bcRl("block/cluster/" + name), (ExistingFileHelper.IResourceType)TEXTURE_TYPE);
        });
        gen.addProvider(event.includeClient(), (DataProvider)new BuddingStateProvider(output, fileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new BuddingItemModelProvider(output, fileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new BuddingLanguageProvider(output));
        gen.addProvider(event.includeServer(), (DataProvider)new BuddingBlockTagsProvider(output, holderProvider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new BuddingLootTableProvider(output));
        gen.addProvider(event.includeServer(), (DataProvider)new BuddingRecipeProvider(output));
    }

    private static ResourceLocation bcRl(String path) {
        return new ResourceLocation("buddingcrystals", path);
    }

    private GeneratorHandler() {
    }
}

