/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import xfacthd.buddingcrystals.common.data.OptionalLootItem;
import xfacthd.buddingcrystals.common.util.BudSet;
import xfacthd.buddingcrystals.common.util.CrystalLoader;
import xfacthd.buddingcrystals.common.util.CrystalSet;

public final class BCContent {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"buddingcrystals");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"buddingcrystals");
    private static final DeferredRegister<LootPoolEntryType> POOL_ENTRY_TYPES = DeferredRegister.create((ResourceKey)Registries.f_257032_, (String)"buddingcrystals");
    public static final Map<String, CrystalSet> ALL_SETS = new HashMap<String, CrystalSet>();
    public static final Map<String, CrystalSet> BUILTIN_SETS = new HashMap<String, CrystalSet>();
    public static final Map<String, CrystalSet> LOADED_SETS = new HashMap<String, CrystalSet>();
    public static final CrystalSet AMETHYST = CrystalSet.builtinAmethyst();
    public static final CrystalSet REDSTONE = CrystalSet.builder("redstone").translation("Redstone").sourceTexture("item/redstone").drop("minecraft:redstone").build();
    public static final CrystalSet DIAMOND = CrystalSet.builder("diamond").translation("Diamond").sourceTexture("item/diamond").drop("minecraft:diamond").build();
    public static final CrystalSet EMERALD = CrystalSet.builder("emerald").translation("Emerald").sourceTexture("item/emerald").drop("minecraft:emerald").build();
    public static final CrystalSet LAPIS_LAZULI = CrystalSet.builder("lapis_lazuli").translation("Lapis Lazuli").sourceTexture("item/lapis_lazuli").drop("minecraft:lapis_lazuli").build();
    public static final CrystalSet GLOWSTONE = CrystalSet.builder("glowstone").translation("Glowstone").sourceTexture("item/glowstone_dust").drop("minecraft:glowstone_dust").build();
    public static final CrystalSet NETHER_QUARTZ = CrystalSet.builder("nether_quartz").translation("Nether Quartz").sourceTexture("item/quartz").drop("minecraft:quartz").build();
    public static final CrystalSet PRISMARINE = CrystalSet.builder("prismarine").translation("Prismarine").sourceTexture("item/prismarine_shard").drop("minecraft:prismarine").build();
    public static final CrystalSet CERTUS_QUARTZ = CrystalSet.builder("certus_quartz").translation("Certus Quartz").sourceTexture("item/certus_quartz_crystal").drop("ae2:certus_quartz_crystal").compatMod("ae2").build();
    public static final CrystalSet FLUIX = CrystalSet.builder("fluix").translation("Fluix").crystalSourceTexture("item/fluix_dust").buddingSourceTexture("block/fluix_block").drop("ae2:fluix_crystal").compatMod("ae2").build();
    public static final CrystalSet SALT = CrystalSet.builder("salt").translation("Salt").sourceTexture("item/salt").drop("mekanism:salt").compatMod("mekanism").growthChance(1).build();
    public static final CrystalSet FLUORITE = CrystalSet.builder("fluorite").translation("Fluorite").sourceTexture("item/fluorite_gem").drop("mekanism:fluorite_gem").compatMod("mekanism").build();
    public static final RegistryObject<Item> CRYSTAL_CATALYST = ITEMS.register("crystal_catalyst", () -> new Item(new Item.Properties()));
    public static final RegistryObject<LootPoolEntryType> OPTIONAL_LOOT_ITEM = POOL_ENTRY_TYPES.register("optional_item", () -> new LootPoolEntryType((Serializer)new OptionalLootItem.Serializer()));
    public static final TagKey<Block> BUDDING_BLOCKS_TAG = BlockTags.create((ResourceLocation)new ResourceLocation("forge", "budding_blocks"));

    public static void register(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
        POOL_ENTRY_TYPES.register(bus);
        CrystalLoader.loadUserSets();
    }

    public static Collection<CrystalSet> allSets() {
        return ALL_SETS.values();
    }

    public static Collection<CrystalSet> builtinSets() {
        return BUILTIN_SETS.values();
    }

    public static Collection<CrystalSet> loadedSets() {
        return LOADED_SETS.values();
    }

    public static Collection<String> builtinNames() {
        return BUILTIN_SETS.keySet();
    }

    public static boolean isBuiltin(String name) {
        return BUILTIN_SETS.containsKey(name);
    }

    public static Iterable<Block> allClusters() {
        return ALL_SETS.values().stream().map(CrystalSet::getBudSet).map(BudSet::blocks).flatMap(Collection::stream).toList();
    }

    private BCContent() {
    }
}

