/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.client.util;

import dev.lukebemish.dynamicassetgenerator.api.PathAwareInputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.ResourceCache;
import dev.lukebemish.dynamicassetgenerator.api.client.AssetResourceCache;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TextureGenerator;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.PaletteCombinedSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.TextureReaderSource;
import net.minecraft.resources.ResourceLocation;
import xfacthd.buddingcrystals.common.util.CrystalSet;

public final class BuddingPalettePlanner {
    private static final AssetResourceCache ASSET_CACHE = (AssetResourceCache)ResourceCache.register((ResourceCache)new AssetResourceCache(new ResourceLocation("buddingcrystals", "assets")));
    private static final ResourceLocation FALLBACK_TEXTURE = BuddingPalettePlanner.rl("forge", "white");
    private static final ResourceLocation EMPTY_TEXTURE = BuddingPalettePlanner.rl("dynamic_asset_generator", "empty");

    public static void plan(CrystalSet set) {
        String name = set.getName();
        BuddingPalettePlanner.plan("block/budding/" + name, set.isActive() ? set.getBuddingSourceTexture() : FALLBACK_TEXTURE, BuddingPalettePlanner.mcRl("block/budding_amethyst"));
        BuddingPalettePlanner.plan("block/small_bud/" + name, set.isActive() ? set.getCrystalSourceTexture() : FALLBACK_TEXTURE, BuddingPalettePlanner.mcRl("block/small_amethyst_bud"));
        BuddingPalettePlanner.plan("block/medium_bud/" + name, set.isActive() ? set.getCrystalSourceTexture() : FALLBACK_TEXTURE, BuddingPalettePlanner.mcRl("block/medium_amethyst_bud"));
        BuddingPalettePlanner.plan("block/large_bud/" + name, set.isActive() ? set.getCrystalSourceTexture() : FALLBACK_TEXTURE, BuddingPalettePlanner.mcRl("block/large_amethyst_bud"));
        BuddingPalettePlanner.plan("block/cluster/" + name, set.isActive() ? set.getCrystalSourceTexture() : FALLBACK_TEXTURE, BuddingPalettePlanner.mcRl("block/amethyst_cluster"));
    }

    public static void planCatalyst() {
        BuddingPalettePlanner.plan("item/crystal_catalyst", BuddingPalettePlanner.mcRl("item/amethyst_shard"), BuddingPalettePlanner.mcRl("item/blaze_powder"));
    }

    private static void plan(String path, ResourceLocation background, ResourceLocation paletted) {
        ASSET_CACHE.planSource((PathAwareInputStreamSource)new TextureGenerator(BuddingPalettePlanner.bcRl(path), (TexSource)new PaletteCombinedSource.Builder().setOverlay((TexSource)new TextureReaderSource.Builder().setPath(EMPTY_TEXTURE).build()).setBackground((TexSource)new TextureReaderSource.Builder().setPath(background).build()).setPaletted((TexSource)new TextureReaderSource.Builder().setPath(paletted).build()).setIncludeBackground(false).setStretchPaletted(true).setExtendPaletteSize(0).build()));
    }

    private static ResourceLocation bcRl(String path) {
        return BuddingPalettePlanner.rl("buddingcrystals", path);
    }

    private static ResourceLocation mcRl(String path) {
        return BuddingPalettePlanner.rl("minecraft", path);
    }

    private static ResourceLocation rl(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    private BuddingPalettePlanner() {
    }
}

