/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.client.dynpack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;
import xfacthd.buddingcrystals.common.BCContent;
import xfacthd.buddingcrystals.common.util.CrystalSet;

public final class DynamicLanguage {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

    public static void run(Map<ResourceLocation, String> cache) {
        TreeMap translations = new TreeMap();
        BCContent.loadedSets().forEach(set -> DynamicLanguage.translate(translations, set, set.getTranslation()));
        String data = GSON.toJson(translations);
        data = JavaUnicodeEscaper.outsideOf((int)0, (int)127).translate((CharSequence)data);
        cache.put(new ResourceLocation("buddingcrystals", "lang/en_us.json"), data);
    }

    private static void translate(Map<String, String> translations, CrystalSet set, String name) {
        DynamicLanguage.add(translations, set.getSmallBud(), "Small " + name + " Bud");
        DynamicLanguage.add(translations, set.getMediumBud(), "Medium " + name + " Bud");
        DynamicLanguage.add(translations, set.getLargeBud(), "Large " + name + " Bud");
        DynamicLanguage.add(translations, set.getCluster(), name + " Cluster");
        DynamicLanguage.add(translations, set.getBuddingBlock(), "Budding " + name);
    }

    private static void add(Map<String, String> translations, Block key, String value) {
        translations.put(key.m_7705_(), value);
    }
}

