/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.grave.data;

import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import dev.quarris.enigmaticgraves.utils.ModRef;
import dev.quarris.enigmaticgraves.utils.PlayerInventoryExtensions;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import lain.mods.cos.api.CosArmorAPI;
import lain.mods.cos.api.inventory.CAStacksBase;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CosmeticArmorReworkedGraveData
implements IGraveData {
    public static final ResourceLocation NAME = ModRef.res("cosmeticarmorreworked");
    public final CAStacksBase caStacksBase = new CAStacksBase();

    public CosmeticArmorReworkedGraveData(CAStacksBase caStacksBase, Collection<ItemEntity> drops) {
        this.caStacksBase.deserializeNBT(caStacksBase.serializeNBT());
        Iterator<ItemEntity> ite = drops.iterator();
        while (ite.hasNext()) {
            ItemStack drop = ite.next().m_32055_();
            for (int slot = 0; slot < caStacksBase.getSlots(); ++slot) {
                ItemStack stack = caStacksBase.getStackInSlot(slot);
                if (!ItemStack.m_41728_((ItemStack)stack, (ItemStack)drop)) continue;
                ite.remove();
            }
        }
    }

    public CosmeticArmorReworkedGraveData(CompoundTag nbt) {
        this.deserializeNBT(nbt);
    }

    @Override
    public void restore(Player player) {
        CAStacksBase lowPrio = CosArmorAPI.getCAStacks((UUID)player.m_20148_());
        for (int slot = 0; slot < lowPrio.getSlots(); ++slot) {
            ItemStack lowPrioItem = lowPrio.getStackInSlot(slot);
            ItemStack highPrioItem = this.caStacksBase.getStackInSlot(slot);
            if (!lowPrioItem.m_41619_() && !highPrioItem.m_41619_()) {
                PlayerInventoryExtensions.tryAddItemToPlayerInvElseDrop(player, -1, lowPrioItem);
                continue;
            }
            if (lowPrioItem.m_41619_()) continue;
            this.caStacksBase.setStackInSlot(slot, lowPrioItem);
        }
        lowPrio.deserializeNBT(this.caStacksBase.serializeNBT());
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public CompoundTag write(CompoundTag nbt) {
        nbt.m_128365_("caStacksBase", (Tag)this.caStacksBase.serializeNBT());
        return nbt;
    }

    @Override
    public void read(CompoundTag nbt) {
        this.caStacksBase.deserializeNBT(nbt.m_128469_("caStacksBase"));
    }
}

