/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.grave;

import dev.quarris.enigmaticgraves.config.GraveConfigs;
import dev.quarris.enigmaticgraves.grave.PlayerGraveEntry;
import dev.quarris.enigmaticgraves.utils.ModRef;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;

public class WorldGraveData
extends SavedData {
    public static final String NAME = "enigmaticgraves";
    private final Map<UUID, LinkedList<PlayerGraveEntry>> playerGraveEntries = new HashMap<UUID, LinkedList<PlayerGraveEntry>>();
    private final Set<UUID> restoredGraves = new HashSet<UUID>();

    public LinkedList<PlayerGraveEntry> getGraveEntriesForPlayer(UUID playerUUID) {
        return this.playerGraveEntries.get(playerUUID);
    }

    public void setGraveRestored(UUID graveUUID) {
        this.restoredGraves.add(graveUUID);
        this.m_77762_();
    }

    public void removeGraveRestored(UUID graveUUID) {
        this.restoredGraves.remove(graveUUID);
        this.m_77762_();
    }

    public boolean isGraveRestored(UUID graveUUID) {
        return this.restoredGraves.contains(graveUUID);
    }

    public void addGraveEntry(Player player, PlayerGraveEntry entry) {
        LinkedList entries = this.playerGraveEntries.computeIfAbsent(player.m_20148_(), k -> new LinkedList());
        if (entries.size() >= (Integer)GraveConfigs.COMMON.graveEntryCount.get()) {
            ModRef.LOGGER.debug("Entries reached max values for " + player.m_7755_());
            ModRef.LOGGER.debug("Removing oldest entry");
            entries.removeLast();
        }
        entries.addFirst(entry);
        this.m_77762_();
    }

    public void clearGraveEntries(Player player) {
        this.playerGraveEntries.remove(player.m_20148_());
        this.m_77762_();
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag playerGraveEntriesNBT = new ListTag();
        for (UUID uuid : this.playerGraveEntries.keySet()) {
            CompoundTag playerGravesNBT = new CompoundTag();
            playerGravesNBT.m_128362_("UUID", uuid);
            List entries = this.playerGraveEntries.get(uuid);
            ListTag entriesNBT = new ListTag();
            for (PlayerGraveEntry entry : entries) {
                entriesNBT.add((Object)entry.serializeNBT());
            }
            playerGravesNBT.m_128365_("Entries", (Tag)entriesNBT);
            playerGraveEntriesNBT.add((Object)playerGravesNBT);
        }
        compound.m_128365_("PlayerGraveEntries", (Tag)playerGraveEntriesNBT);
        ListTag restoredGravesNBT = new ListTag();
        for (UUID restoredGraveUUID : this.restoredGraves) {
            restoredGravesNBT.add((Object)NbtUtils.m_129226_((UUID)restoredGraveUUID));
        }
        compound.m_128365_("RestoredGraves", (Tag)restoredGravesNBT);
        return compound;
    }

    public static WorldGraveData load(CompoundTag tag) {
        WorldGraveData data = new WorldGraveData();
        data.loadInternal(tag);
        return data;
    }

    public void loadInternal(CompoundTag nbt) {
        this.playerGraveEntries.clear();
        this.restoredGraves.clear();
        ListTag playerGraveEntriesNBT = nbt.m_128437_("PlayerGraveEntries", 10);
        for (Tag inbt : playerGraveEntriesNBT) {
            CompoundTag playerGravesNBT = (CompoundTag)inbt;
            UUID uuid = playerGravesNBT.m_128342_("UUID");
            ListTag entriesNBT = playerGravesNBT.m_128437_("Entries", 10);
            LinkedList entries = this.playerGraveEntries.computeIfAbsent(uuid, k -> new LinkedList());
            for (int i = 0; i < entriesNBT.size(); ++i) {
                CompoundTag entryNBT = entriesNBT.m_128728_(i);
                PlayerGraveEntry entry = new PlayerGraveEntry(entryNBT);
                entries.addLast(entry);
            }
        }
        ListTag restoredGravesNBT = nbt.m_128437_("RestoredGraves", 10);
        for (Tag uuidNBT : restoredGravesNBT) {
            UUID restoredGraveUUID = NbtUtils.m_129233_((Tag)uuidNBT);
            this.restoredGraves.add(restoredGraveUUID);
        }
    }
}

