/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.grave;

import dev.quarris.enigmaticgraves.grave.GraveManager;
import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.common.util.INBTSerializable;

public class PlayerGraveEntry
implements INBTSerializable<CompoundTag> {
    public Inventory inventory;
    public UUID graveUUID;
    public BlockPos gravePos;
    public Date timestamp;
    public List<IGraveData> dataList = new ArrayList<IGraveData>();
    private boolean restored;

    public PlayerGraveEntry(Inventory inventory) {
        this.inventory = new Inventory(inventory.f_35978_);
        this.inventory.m_36006_(inventory);
        this.timestamp = new Date();
    }

    public PlayerGraveEntry(CompoundTag nbt) {
        this.dataList = new ArrayList<IGraveData>();
        this.deserializeNBT(nbt);
    }

    public String getEntryName(int id) {
        return String.format("death_%d_%s", id, GraveManager.TIMESTAMP_FORMAT.format(this.timestamp));
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("Grave", this.graveUUID);
        nbt.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)this.gravePos));
        nbt.m_128356_("Timestamp", this.timestamp.getTime());
        ListTag dataNBT = new ListTag();
        for (IGraveData data : this.dataList) {
            dataNBT.add((Object)data.serializeNBT());
        }
        nbt.m_128365_("Data", (Tag)dataNBT);
        nbt.m_128379_("Restored", this.restored);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.graveUUID = nbt.m_128342_("Grave");
        this.gravePos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Pos"));
        this.timestamp = new Date(nbt.m_128454_("Timestamp"));
        ListTag dataNBT = nbt.m_128437_("Data", 10);
        for (Tag inbt : dataNBT) {
            CompoundTag graveNBT = (CompoundTag)inbt;
            ResourceLocation name = new ResourceLocation(graveNBT.m_128461_("Name"));
            IGraveData data = GraveManager.GRAVE_DATA_SUPPLIERS.get(name).apply(graveNBT);
            this.dataList.add(data);
        }
        this.restored = nbt.m_128471_("Restored");
    }

    public void setRestored() {
        this.restored = true;
    }

    public boolean isRestored() {
        return this.restored;
    }
}

