/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.content;

import dev.quarris.enigmaticgraves.config.GraveConfigs;
import dev.quarris.enigmaticgraves.grave.GraveManager;
import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import dev.quarris.enigmaticgraves.setup.Registry;
import dev.quarris.enigmaticgraves.utils.ClientHelper;
import dev.quarris.enigmaticgraves.utils.ModRef;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class GraveEntity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.m_135353_(GraveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<String> OWNER_NAME = SynchedEntityData.m_135353_(GraveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private List<IGraveData> contents = new ArrayList<IGraveData>();
    private boolean restored;

    public static GraveEntity createGrave(Player player, List<IGraveData> graveData) {
        GraveEntity grave = new GraveEntity(player);
        BlockPos.MutableBlockPos spawnPos = new BlockPos.MutableBlockPos();
        boolean spawnBlockBelow = GraveManager.getSpawnPosition(player.m_9236_(), player.m_20182_(), spawnPos);
        if (spawnBlockBelow) {
            ResourceLocation blockName = new ResourceLocation((String)GraveConfigs.COMMON.graveFloorBlock.get());
            BlockState state = ((Block)ForgeRegistries.BLOCKS.getValue(blockName)).m_49966_();
            player.m_9236_().m_7731_(spawnPos.m_7495_(), state, 3);
            player.m_9236_().m_46796_(2001, (BlockPos)spawnPos, Block.m_49956_((BlockState)state));
        }
        grave.m_19915_(player.m_146909_(), 0.0f);
        grave.m_6034_((float)spawnPos.m_123341_() + player.m_20205_() / 2.0f, spawnPos.m_123342_(), (float)spawnPos.m_123343_() + player.m_20205_() / 2.0f);
        grave.setContents(graveData);
        return grave;
    }

    public GraveEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public GraveEntity(Player player) {
        this((EntityType)Registry.GRAVE_ENTITY_TYPE.get(), player.m_9236_());
        this.setOwner(player);
    }

    public void m_8119_() {
        if (!this.m_9236_().m_5776_() && GraveManager.getWorldGraveData((LevelAccessor)this.m_9236_()).isGraveRestored(this.m_20148_())) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            GraveManager.getWorldGraveData((LevelAccessor)this.m_9236_()).removeGraveRestored(this.m_20148_());
        }
        super.m_8119_();
    }

    public boolean m_142038_() {
        return this.m_9236_().f_46443_ ? ClientHelper.shouldGlowOnClient(this) : super.m_142038_();
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER, Optional.empty());
        this.f_19804_.m_135372_(OWNER_NAME, (Object)"");
    }

    public void m_6123_(Player player) {
        if (((Boolean)GraveConfigs.COMMON.sneakRetrieval.get()).booleanValue() && player.m_6144_() && this.belongsTo(player)) {
            this.restoreGrave(player);
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack heldItem;
        if (this.belongsTo(player)) {
            this.restoreGrave(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (player.m_7500_() && (heldItem = player.m_21120_(hand)).m_41720_() == Registry.GRAVE_FINDER_ITEM.get() && !heldItem.m_41782_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    private void restoreGrave(Player player) {
        if (!this.m_6084_() || this.m_9236_().m_5776_()) {
            return;
        }
        for (int slot = 0; slot < player.m_150109_().m_6643_(); ++slot) {
            CompoundTag nbt;
            ItemStack stack = player.m_150109_().m_8020_(slot);
            if (stack.m_41720_() != Registry.GRAVE_FINDER_ITEM.get() || !stack.m_41782_() || (nbt = stack.m_41783_()) == null || !nbt.m_128441_("GraveUUID") || !nbt.m_128342_("GraveUUID").equals(this.m_20148_())) continue;
            player.m_150109_().m_6836_(slot, ItemStack.f_41583_);
            break;
        }
        for (IGraveData data : this.contents) {
            data.restore(player);
        }
        GraveManager.setGraveRestored(this.getOwnerUUID(), this);
        this.restored = true;
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (!this.m_9236_().f_46443_ && !this.restored) {
            ModRef.LOGGER.warn("Grave at {} was removed without being restored!", (Object)this.m_20183_());
        }
    }

    private boolean belongsTo(Player player) {
        return player.m_20148_().equals(this.getOwnerUUID());
    }

    protected void m_7380_(CompoundTag compound) {
        CompoundTag graveNBT = new CompoundTag();
        ListTag contentNBT = new ListTag();
        for (IGraveData data : this.contents) {
            contentNBT.add((Object)data.serializeNBT());
        }
        graveNBT.m_128365_("Content", (Tag)contentNBT);
        if (this.getOwnerUUID() != null) {
            graveNBT.m_128362_("Owner", this.getOwnerUUID());
        }
        if (!this.getOwnerName().isEmpty()) {
            graveNBT.m_128359_("OwnerName", this.getOwnerName());
        }
        compound.m_128365_("Grave", (Tag)graveNBT);
    }

    protected void m_7378_(CompoundTag compound) {
        CompoundTag graveNBT = compound.m_128469_("Grave");
        ArrayList<IGraveData> dataList = new ArrayList<IGraveData>();
        ListTag contentNBT = graveNBT.m_128437_("Content", 10);
        for (Tag inbt : contentNBT) {
            CompoundTag dataNBT = (CompoundTag)inbt;
            ResourceLocation name = new ResourceLocation(dataNBT.m_128461_("Name"));
            IGraveData data = GraveManager.GRAVE_DATA_SUPPLIERS.get(name).apply(dataNBT);
            dataList.add(data);
        }
        this.setContents(dataList);
        if (graveNBT.m_128441_("Owner")) {
            this.f_19804_.m_135381_(OWNER, Optional.of(graveNBT.m_128342_("Owner")));
        }
        if (graveNBT.m_128441_("OwnerName")) {
            this.f_19804_.m_135381_(OWNER_NAME, (Object)graveNBT.m_128461_("OwnerName"));
        }
    }

    public void setContents(List<IGraveData> contents) {
        this.contents = contents;
    }

    public void setOwner(Player owner) {
        this.f_19804_.m_135381_(OWNER, Optional.of(owner.m_20148_()));
        this.f_19804_.m_135381_(OWNER_NAME, (Object)owner.m_7755_().getString());
    }

    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(OWNER_NAME);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(OWNER)).orElse(null);
    }

    public boolean m_6087_() {
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

