/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.BlockStatesMap;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.IReloadableData;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;

public class SuctionHoppers
implements IReloadableData {
    protected ForgeConfigSpec.ConfigValue<List<? extends String>> configValues;
    protected BlockStatesMap<Integer> states = new BlockStatesMap();

    public SuctionHoppers(AbstractForgeMod.ConfigValueBuilder builder, String comment, String[] defaultValues) {
        this.configValues = builder.comment(comment).defineList("suctionHoppers", defaultValues, str -> {
            try {
                String[] split = str.split(",");
                if (UnitId.from(split[0].trim()).isEmpty()) {
                    return false;
                }
                int range = Integer.parseInt(split[1].trim());
                if (!IntBounds.between(1, 64).encloses(range)) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            return true;
        });
    }

    public boolean containsKey(BlockState state) {
        return this.states.containsKey(state);
    }

    public Optional<Integer> getSuctionRange(BlockState state) {
        return Optional.ofNullable(this.states.get(state));
    }

    @Override
    public void loadData() {
        this.states = BlockStatesMap.parseIntegers(((List)this.configValues.get()).toArray(new String[0]));
    }
}

