/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.reforging;

import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.reforging.ReforgingRecipe;
import dev.shadowsoffire.apotheosis.adventure.affix.reforging.ReforgingTableTile;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.util.ApothMiscUtil;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import dev.shadowsoffire.placebo.menu.BlockEntityMenu;
import dev.shadowsoffire.placebo.menu.PlaceboContainerMenu;
import dev.shadowsoffire.placebo.util.EnchantmentUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ReforgingMenu
extends BlockEntityMenu<ReforgingTableTile> {
    public static final String REFORGE_SEED = "apoth_reforge_seed";
    protected final Player player;
    protected InternalItemHandler itemInv = new InternalItemHandler(1);
    protected InternalItemHandler choicesInv = new InternalItemHandler(3);
    protected final RandomSource random = new XoroshiroRandomSource(0L);
    protected final int[] costs = new int[3];
    protected int seed = -1;

    public ReforgingMenu(int id, Inventory inv, BlockPos pos) {
        super((MenuType)Adventure.Menus.REFORGING.get(), id, inv, pos);
        this.player = inv.f_35978_;
        this.m_38897_((Slot)new PlaceboContainerMenu.UpdatingSlot(this.itemInv, 0, 81, 62, stack -> !LootCategory.forItem(stack).isNone()){

            public int m_6641_() {
                return 1;
            }

            public int m_5866_(ItemStack pStack) {
                return 1;
            }
        });
        this.m_38897_((Slot)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, ((ReforgingTableTile)this.tile).inv, 0, 39, 40, ((ReforgingTableTile)this.tile)::isValidRarityMat));
        this.m_38897_((Slot)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, ((ReforgingTableTile)this.tile).inv, 1, 123, 86, stack -> stack.m_41720_() == Adventure.Items.SIGIL_OF_REBIRTH.get()));
        this.m_38897_((Slot)new ReforgingResultSlot((IItemHandler)this.choicesInv, 0, 27, 135));
        this.m_38897_((Slot)new ReforgingResultSlot((IItemHandler)this.choicesInv, 1, 81, 135));
        this.m_38897_((Slot)new ReforgingResultSlot((IItemHandler)this.choicesInv, 2, 135, 135));
        this.addPlayerSlots(inv, 8, 184);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && !LootCategory.forItem(stack).isNone(), 0, 1);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && ((ReforgingTableTile)this.tile).isValidRarityMat((ItemStack)stack), 1, 2);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && stack.m_41720_() == Adventure.Items.SIGIL_OF_REBIRTH.get(), 2, 3);
        this.mover.registerRule((stack, slot) -> slot < this.playerInvStart, this.playerInvStart, this.hotbarStart + 9);
        this.registerInvShuffleRules();
        this.updateSeed();
        this.m_38895_(DataSlot.m_39406_((int[])this.costs, (int)0));
        this.m_38895_(DataSlot.m_39406_((int[])this.costs, (int)1));
        this.m_38895_(DataSlot.m_39406_((int[])this.costs, (int)2));
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.m_150411_(pPlayer, (Container)new RecipeWrapper((IItemHandlerModifiable)this.itemInv));
    }

    protected void updateSeed() {
        int seed = this.player.getPersistentData().m_128451_(REFORGE_SEED);
        if (seed == 0) {
            seed = this.player.f_19796_.m_188502_();
            this.player.getPersistentData().m_128405_(REFORGE_SEED, seed);
        }
        this.seed = seed;
    }

    public int getMatCount() {
        return this.m_38853_(1).m_7993_().m_41613_();
    }

    public int getSigilCount() {
        return this.m_38853_(2).m_7993_().m_41613_();
    }

    @Nullable
    public LootRarity getRarity() {
        ItemStack s = this.m_38853_(1).m_7993_();
        if (s.m_41619_()) {
            return null;
        }
        return RarityRegistry.getMaterialRarity(s.m_41720_()).getOptional().orElse(null);
    }

    public int getSigilCost(int slot) {
        return this.costs[0] * ++slot;
    }

    public int getMatCost(int slot) {
        return this.costs[1] * ++slot;
    }

    public int getLevelCost(int slot) {
        return this.costs[2] * ++slot;
    }

    public void m_6199_(Container pContainer) {
        ReforgingRecipe recipe;
        LootRarity rarity = this.getRarity();
        if (rarity != null && (recipe = ((ReforgingTableTile)this.tile).getRecipeFor(rarity)) != null) {
            this.costs[0] = recipe.sigilCost();
            this.costs[1] = recipe.matCost();
            this.costs[2] = recipe.levelCost();
        }
        ItemStack input = this.m_38853_(0).m_7993_();
        for (int slot = 0; slot < 3; ++slot) {
            if (!input.m_41619_() && rarity != null) {
                RandomSource rand = this.random;
                rand.m_188584_((long)(this.seed ^ ForgeRegistries.ITEMS.getKey((Object)input.m_41720_()).hashCode() + slot));
                ItemStack output = LootController.createLootItem(input.m_41777_(), rarity, rand);
                this.choicesInv.setStackInSlot(slot, output);
                continue;
            }
            this.choicesInv.setStackInSlot(slot, ItemStack.f_41583_);
        }
        super.m_6199_(pContainer);
        ((ReforgingTableTile)this.tile).m_6596_();
    }

    public class ReforgingResultSlot
    extends SlotItemHandler {
        public ReforgingResultSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return false;
        }

        public boolean m_8010_(Player playerIn) {
            ItemStack input = ReforgingMenu.this.m_38853_(0).m_7993_();
            LootRarity rarity = ReforgingMenu.this.getRarity();
            ReforgingRecipe recipe = ((ReforgingTableTile)ReforgingMenu.this.tile).getRecipeFor(rarity);
            if (recipe == null || input.m_41619_()) {
                return false;
            }
            int sigils = ReforgingMenu.this.getSigilCount();
            int sigilCost = ReforgingMenu.this.getSigilCost(this.getSlotIndex());
            int mats = ReforgingMenu.this.getMatCount();
            int matCost = ReforgingMenu.this.getMatCost(this.getSlotIndex());
            int levels = ReforgingMenu.this.player.f_36078_;
            int levelCost = ReforgingMenu.this.getLevelCost(this.getSlotIndex());
            if (!(sigils >= sigilCost && mats >= matCost && levels >= levelCost || ReforgingMenu.this.player.m_7500_())) {
                return false;
            }
            return super.m_8010_(playerIn);
        }

        public void m_142406_(Player player, ItemStack stack) {
            if (!player.m_9236_().f_46443_) {
                ReforgingMenu.this.m_38853_(0).m_5852_(ItemStack.f_41583_);
                if (!player.m_7500_()) {
                    int sigilCost = ReforgingMenu.this.getSigilCost(this.getSlotIndex());
                    int matCost = ReforgingMenu.this.getMatCost(this.getSlotIndex());
                    int levelCost = ReforgingMenu.this.getLevelCost(this.getSlotIndex());
                    ReforgingMenu.this.m_38853_(1).m_7993_().m_41774_(matCost);
                    ReforgingMenu.this.m_38853_(2).m_7993_().m_41774_(sigilCost);
                    EnchantmentUtils.chargeExperience((Player)player, (int)ApothMiscUtil.getExpCostForSlot(levelCost, this.getSlotIndex()));
                }
                player.getPersistentData().m_128405_(ReforgingMenu.REFORGE_SEED, player.f_19796_.m_188502_());
                ReforgingMenu.this.updateSeed();
            }
            player.m_5496_(SoundEvents.f_11862_, 0.99f, player.m_9236_().f_46441_.m_188501_() * 0.25f + 1.0f);
            player.m_5496_(SoundEvents.f_144054_, 0.34f, player.m_9236_().f_46441_.m_188501_() * 0.2f + 0.8f);
            player.m_5496_(SoundEvents.f_12471_, 0.45f, player.m_9236_().f_46441_.m_188501_() * 0.5f + 0.75f);
        }
    }
}

