/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.core.impl.screen;

import com.gitlab.cdagaming.unilib.core.CoreUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.awt.Color;
import java.util.function.Function;

public class ScreenConstants {
    public static final ColorData DEFAULT_TOOLTIP_BACKGROUND = new ColorData(new ColorSection(16, 0, 16, 240));
    public static final ColorData DEFAULT_TOOLTIP_BORDER = new ColorData(new ColorSection(80, 0, 255, 80), new ColorSection(40, 0, 127, 80));
    public static final ColorData DEFAULT_ALT_SCREEN_BACKGROUND = new ColorData(new ColorSection(16, 16, 16, 192), new ColorSection(16, 16, 16, 208));
    private static final Function<Integer, String> DEFAULT_BUTTON_BACKGROUND_SUPPLIER = protocol -> "minecraft:" + (CoreUtils.isLegacyHard(protocol) ? "/gui/gui.png" : "textures/gui/widgets.png");
    private static final String DEFAULT_BUTTON_BACKGROUND = ScreenConstants.getDefaultButtonBackground(CoreUtils.MCBuildProtocol);
    private static final Function<Integer, String> DEFAULT_GUI_BACKGROUND_SUPPLIER = protocol -> "minecraft:" + (CoreUtils.isLegacyHard(protocol) ? (CoreUtils.isLegacyAlpha(protocol) ? "/dirt.png" : "/gui/background.png") : "textures/gui/options_background.png");
    private static final String DEFAULT_GUI_BACKGROUND = ScreenConstants.getDefaultGUIBackground(CoreUtils.MCBuildProtocol);
    public static final ColorData DEFAULT_SCREEN_BACKGROUND = new ColorData(new ColorSection(64, 64, 64, 255), ScreenConstants.getDefaultGUIBackground());
    private static final TooltipData DEFAULT_TOOLTIP = new TooltipData(true, DEFAULT_TOOLTIP_BACKGROUND, DEFAULT_TOOLTIP_BORDER);
    private static final TooltipData EMPTY_TOOLTIP = new TooltipData(true, null, null);

    public static String getDefaultButtonBackground(int protocol) {
        return DEFAULT_BUTTON_BACKGROUND_SUPPLIER.apply(protocol);
    }

    public static String getDefaultButtonBackground() {
        return DEFAULT_BUTTON_BACKGROUND;
    }

    public static String getDefaultGUIBackground(int protocol) {
        return DEFAULT_GUI_BACKGROUND_SUPPLIER.apply(protocol);
    }

    public static String getDefaultGUIBackground() {
        return DEFAULT_GUI_BACKGROUND;
    }

    public static TooltipData getEmptyTooltip() {
        return EMPTY_TOOLTIP;
    }

    public static TooltipData getDefaultTooltip() {
        return DEFAULT_TOOLTIP;
    }

    public record TooltipData(boolean renderTooltips, ColorData backgroundColor, ColorData borderColor) {
    }

    public record ColorData(ColorSection start, ColorSection end, String texLocation, double texLevel, double colorLevel, boolean useFullTexture, double textureWidth, double textureHeight) {
        private final ColorSection end;
        private final String texLocation;

        public ColorData(ColorSection start, ColorSection end, String texLocation, double texLevel, double colorLevel, boolean useFullTexture) {
            this(start, end, texLocation, texLevel, colorLevel, useFullTexture, 32.0, 32.0);
        }

        public ColorData(ColorSection start, ColorSection end, String texLocation, double texLevel, double colorLevel) {
            this(start, end, texLocation, texLevel, colorLevel, true);
        }

        public ColorData(ColorSection start, ColorSection end, String texLocation) {
            this(start, end, texLocation, 0.0, 300.0);
        }

        public ColorData(ColorSection start, ColorSection end) {
            this(start, end, "");
        }

        public ColorData(ColorSection start, String texLocation, double texLevel, double colorLevel, boolean useFullTexture, double textureWidth, double textureHeight) {
            this(start, null, texLocation, texLevel, colorLevel, useFullTexture, textureWidth, textureHeight);
        }

        public ColorData(ColorSection start, String texLocation, double texLevel, double colorLevel, boolean useFullTexture) {
            this(start, texLocation, texLevel, colorLevel, useFullTexture, 32.0, 32.0);
        }

        public ColorData(ColorSection start, String texLocation, double texLevel, double colorLevel) {
            this(start, texLocation, texLevel, colorLevel, true);
        }

        public ColorData(ColorSection start, String texLocation) {
            this(start, texLocation, 0.0, 300.0);
        }

        public ColorData(ColorSection start) {
            this(start, "");
        }

        public ColorData(Color start, Color end, String texLocation, double texLevel, double colorLevel, boolean useFullTexture, double textureWidth, double textureHeight) {
            this(new ColorSection(start), end != null ? new ColorSection(end) : null, texLocation, texLevel, colorLevel, useFullTexture, textureWidth, textureHeight);
        }

        public ColorData(Color start, Color end, String texLocation, double texLevel, double colorLevel, boolean useFullTexture) {
            this(start, end, texLocation, texLevel, colorLevel, useFullTexture, 32.0, 32.0);
        }

        public ColorData(Color start, Color end, String texLocation, double texLevel, double colorLevel) {
            this(start, end, texLocation, texLevel, colorLevel, true);
        }

        public ColorData(Color start, Color end, String texLocation) {
            this(start, end, texLocation, 0.0, 300.0);
        }

        public ColorData(Color start, Color end) {
            this(start, end, "");
        }

        public ColorData(Color start, String texLocation, double texLevel, double colorLevel, boolean useFullTexture, double textureWidth, double textureHeight) {
            this(start, null, texLocation, texLevel, colorLevel, useFullTexture, textureWidth, textureHeight);
        }

        public ColorData(Color start, String texLocation, double texLevel, double colorLevel, boolean useFullTexture) {
            this(start, texLocation, texLevel, colorLevel, useFullTexture, 32.0, 32.0);
        }

        public ColorData(Color start, String texLocation, double texLevel, double colorLevel) {
            this(start, texLocation, texLevel, colorLevel, true);
        }

        public ColorData(Color start, String texLocation) {
            this(start, texLocation, 0.0, 300.0);
        }

        public ColorData(Color start) {
            this(start, "");
        }

        public ColorData(String texLocation, double texLevel, double textureWidth, double textureHeight) {
            this(new ColorSection(), texLocation, texLevel, 300.0, true, textureWidth, textureHeight);
        }

        public ColorData(String texLocation, double texLevel) {
            this(texLocation, texLevel, 32.0, 32.0);
        }

        public ColorData(String texLocation) {
            this(texLocation, 0.0);
        }

        public ColorData() {
            this("");
        }

        public ColorData(ColorData other) {
            this(other.start, other.end, other.texLocation);
        }

        public boolean hasEnd() {
            return this.end != null;
        }

        public ColorSection end() {
            return this.hasEnd() ? this.end : this.start();
        }

        public Color startColor() {
            return this.start().color();
        }

        public Color endColor() {
            return this.end().color();
        }

        public boolean hasTexLocation() {
            return !StringUtils.isNullOrEmpty(this.texLocation);
        }

        public String texLocation() {
            return this.hasTexLocation() ? this.texLocation : "";
        }
    }

    public record ColorSection(int red, int green, int blue, int alpha) {
        public ColorSection(Color color) {
            this(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }

        public ColorSection(ColorSection other) {
            this(other.red, other.green, other.blue, other.alpha);
        }

        public ColorSection() {
            this(Color.white);
        }

        public Color color() {
            return StringUtils.getColorFrom(this.red(), this.green(), this.blue(), this.alpha());
        }
    }
}

