/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class RollingBuffer<T>
implements Iterable<T> {
    private final Object[] buffer;
    private int start = 0;
    private int size = 0;

    public RollingBuffer(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be > 0");
        }
        this.buffer = new Object[capacity];
    }

    public void push(T element) {
        if (this.size < this.buffer.length) {
            this.buffer[(this.start + this.size) % this.buffer.length] = element;
            ++this.size;
        } else {
            this.buffer[this.start] = element;
            this.start = (this.start + 1) % this.buffer.length;
        }
    }

    public T get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + ", size: " + this.size);
        }
        int realIndex = (this.start + index) % this.buffer.length;
        return (T)this.buffer[realIndex];
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.size == this.buffer.length;
    }

    public void fillAll(T element) {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.push(element);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int current = 0;

            @Override
            public boolean hasNext() {
                return this.current < RollingBuffer.this.size;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return RollingBuffer.this.get(this.current++);
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RollingBuffer{");
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.get(i));
            if (i >= this.size - 1) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

