/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface IModuleContainerItem
extends IItemHUDProvider {
    default public List<Module<?>> getModules(ItemStack stack) {
        return ModuleHelper.get().loadAll(stack);
    }

    @Nullable
    default public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getModule(ItemStack stack, IModuleDataProvider<MODULE> typeProvider) {
        return IModuleHelper.INSTANCE.load(stack, typeProvider);
    }

    default public boolean supportsModule(ItemStack stack, IModuleDataProvider<?> typeProvider) {
        return IModuleHelper.INSTANCE.getSupported(stack).contains(typeProvider.getModuleData());
    }

    default public void addModuleDetails(ItemStack stack, List<Component> tooltip) {
        for (Module<?> module : this.getModules(stack)) {
            ModuleData<?> data = module.getData();
            if (module.getInstalledCount() > 1) {
                MutableComponent amount = MekanismLang.GENERIC_FRACTION.translate(module.getInstalledCount(), data.getMaxStackSize());
                tooltip.add((Component)MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(EnumColor.GRAY, data, amount));
                continue;
            }
            tooltip.add((Component)TextComponentUtil.build(EnumColor.GRAY, data));
        }
    }

    default public boolean hasModule(ItemStack stack, IModuleDataProvider<?> type) {
        CompoundTag modules = ItemDataUtils.getCompound(stack, "modules");
        return modules.m_128425_(type.getRegistryName().toString(), 10);
    }

    default public boolean isModuleEnabled(ItemStack stack, IModuleDataProvider<?> type) {
        IModule<?> module = this.getModule(stack, type);
        return module != null && module.isEnabled();
    }

    default public void removeModule(ItemStack stack, ModuleData<?> type) {
        IModule module = ModuleHelper.get().load(stack, (IModuleDataProvider)type);
        if (module != null) {
            if (((Module)module).getInstalledCount() > 1) {
                ((Module)module).setInstalledCount(((Module)module).getInstalledCount() - 1);
                ((Module)module).save(null);
                ((Module)module).onRemoved(false);
            } else {
                CompoundTag modules = ItemDataUtils.getCompound(stack, "modules");
                modules.m_128473_(type.getRegistryName().toString());
                ((Module)module).onRemoved(true);
            }
        }
    }

    default public void addModule(ItemStack stack, ModuleData<?> type) {
        IModule module = ModuleHelper.get().load(stack, (IModuleDataProvider)type);
        if (module == null) {
            ItemDataUtils.getOrAddCompound(stack, "modules").m_128365_(type.getRegistryName().toString(), (Tag)new CompoundTag());
            ((Module)ModuleHelper.get().load(stack, (IModuleDataProvider)type)).onAdded(true);
        } else {
            ((Module)module).setInstalledCount(((Module)module).getInstalledCount() + 1);
            ((Module)module).save(null);
            ((Module)module).onAdded(false);
        }
    }

    @Override
    default public void addHUDStrings(List<Component> list, Player player, ItemStack stack, EquipmentSlot slotType) {
        for (Module<?> module : this.getModules(stack)) {
            if (!module.renderHUD()) continue;
            module.addHUDStrings(player, list);
        }
    }

    default public List<IHUDElement> getHUDElements(Player player, ItemStack stack) {
        ArrayList<IHUDElement> ret = new ArrayList<IHUDElement>();
        for (Module<?> module : this.getModules(stack)) {
            if (!module.renderHUD()) continue;
            module.addHUDElements(player, ret);
        }
        return ret;
    }
}

