/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.utils;

import java.util.ArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class CommonUtils {
    public static String getEdibleMeatItemNames(boolean includeRottenFlesh) {
        ArrayList<String> edibleMeatItemNames = new ArrayList<String>();
        for (ResourceLocation key : BuiltInRegistries.f_257033_.m_6566_()) {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(key);
            FoodProperties foodProperties = item.m_41473_();
            if (includeRottenFlesh) {
                if (foodProperties == null || !item.m_41472_() || !foodProperties.m_38746_()) continue;
                edibleMeatItemNames.add(key.toString());
                continue;
            }
            if (foodProperties == null || !item.m_41472_() || !foodProperties.m_38746_() || item == Items.f_42583_) continue;
            edibleMeatItemNames.add(key.toString());
        }
        return String.join((CharSequence)", ", edibleMeatItemNames);
    }

    public static Ingredient createTagIngredient(String tagId) {
        String tagLocationStr = tagId.trim().substring(1);
        ResourceLocation tagLocation = new ResourceLocation(tagLocationStr);
        return Ingredient.m_204132_((TagKey)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagLocation));
    }

    public static String makeKey(EntityType<?> type, boolean input, DyeColor color) {
        return type.toString() + ":" + input + ":" + (color != null ? color.m_41065_() : "none");
    }

    @NotNull
    public static Ingredient safe(Ingredient ing) {
        return ing == null ? Ingredient.f_43901_ : ing;
    }
}

