/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teamresourceful.resourcefullib.common.lib.Constants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericMemoryPack
implements PackResources {
    private final Map<ResourceLocation, IoSupplier<InputStream>> data = new HashMap<ResourceLocation, IoSupplier<InputStream>>();
    private final JsonObject metaData;
    private final PackType allowedType;
    private final String id;

    protected GenericMemoryPack(PackType type, String id, JsonObject meta) {
        this.metaData = meta;
        this.allowedType = type;
        this.id = id;
    }

    private boolean isTypeAllowed(PackType type) {
        return this.allowedType.equals((Object)type);
    }

    public void putData(PackType type, ResourceLocation location, IoSupplier<InputStream> supplier) {
        if (!this.isTypeAllowed(type)) {
            return;
        }
        this.data.put(location, supplier);
    }

    public void putJson(PackType type, ResourceLocation location, JsonElement json) {
        this.putData(type, location, (IoSupplier<InputStream>)((IoSupplier)() -> new ByteArrayInputStream(Constants.GSON.toJson(json).getBytes(StandardCharsets.UTF_8))));
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... files) {
        String file = String.join((CharSequence)"/", files);
        if (file.contains("/") || file.contains("\\")) {
            throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
        }
        return null;
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(@NotNull PackType type, @NotNull ResourceLocation location) {
        if (!this.isTypeAllowed(type)) {
            return null;
        }
        return this.data.getOrDefault(location, null);
    }

    public void m_8031_(@NotNull PackType type, @NotNull String namespace, @NotNull String path, @NotNull PackResources.ResourceOutput output) {
        if (!this.isTypeAllowed(type)) {
            return;
        }
        this.data.entrySet().stream().filter(entry -> ((ResourceLocation)entry.getKey()).m_135827_().equals(namespace)).filter(entry -> ((ResourceLocation)entry.getKey()).m_135815_().startsWith(path)).forEach(entry -> output.accept((Object)((ResourceLocation)entry.getKey()), (Object)((IoSupplier)entry.getValue())));
    }

    @NotNull
    public Set<String> m_5698_(@NotNull PackType type) {
        if (!this.isTypeAllowed(type)) {
            return Collections.emptySet();
        }
        return this.data.keySet().stream().map(ResourceLocation::m_135827_).collect(Collectors.toSet());
    }

    @Nullable
    public <T> T m_5550_(@NotNull MetadataSectionSerializer<T> serializer) {
        if (!serializer.m_7991_().equals("pack")) {
            return null;
        }
        return (T)serializer.m_6322_(this.metaData);
    }

    @NotNull
    public String m_5542_() {
        return this.id;
    }

    public boolean m_246538_() {
        return true;
    }

    public void close() {
        for (IoSupplier<InputStream> value : this.data.values()) {
            try {
                ((InputStream)value.m_247737_()).close();
            }
            catch (IOException e) {
                Constants.LOGGER.error("Failed to close input stream", (Throwable)e);
            }
        }
    }
}

