/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client.gui;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterConfigScreen;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterScreen;
import dev.ftb.mods.ftbfiltersystem.client.gui.GhostDropReceiver;
import dev.ftb.mods.ftbfiltersystem.client.gui.widget.CustomSelectionList;
import dev.ftb.mods.ftbfiltersystem.filter.ModFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModConfigScreen
extends AbstractFilterConfigScreen<ModFilter>
implements GhostDropReceiver {
    private static String lastSearch;
    private final List<ModData> matchingModData = new ArrayList<ModData>();
    private EditBox searchField;
    private ModList modList;

    public ModConfigScreen(ModFilter filter, AbstractFilterScreen parentScreen) {
        super(filter, parentScreen, 200, 176);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.searchField = this.makeSearchEditBox(this.leftPos + 8, this.topPos + 20, () -> lastSearch, s -> {
            lastSearch = s;
        });
        this.updateSearchEntries();
        this.modList = new ModList(this.f_96541_, this.getListWidth() + 8, this.getListHeight(), this.topPos + 32, this.topPos + 35 + this.getListHeight());
        this.modList.m_93507_(this.leftPos + 8);
        this.modList.m_93488_(false);
        this.modList.m_93496_(false);
        this.m_7787_((GuiEventListener)this.modList);
        this.modList.m_6702_().stream().filter(child -> child.modData.modId().equals(((ModFilter)this.filter).getStringArg())).findFirst().ifPresent(entry -> this.modList.selectAndCenter(entry));
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        this.modList.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    @Override
    @Nullable
    protected ModFilter makeNewFilter() {
        return this.modList.m_93511_() != null ? new ModFilter(((ModFilter)this.filter).getParent(), ((ModList.ModEntry)this.modList.m_93511_()).modData.modId) : null;
    }

    @Override
    protected void doScheduledUpdate() {
        this.updateSearchEntries();
        this.modList.addChildren();
    }

    private int getListHeight() {
        return 148;
    }

    private int getListWidth() {
        return 176;
    }

    private void updateSearchEntries() {
        String srch = this.searchField.m_94155_().toLowerCase(Locale.ROOT);
        this.matchingModData.clear();
        this.matchingModData.addAll(Platform.getMods().stream().filter(mod -> srch.isEmpty() || mod.getModId().toLowerCase(Locale.ROOT).contains(srch)).map(mod -> new ModData(mod.getModId(), mod.getName())).sorted().toList());
    }

    @Override
    public Rect2i getGhostDropRegion() {
        return new Rect2i(this.leftPos + 9, this.topPos + 33, this.getListWidth() + 6, this.getListHeight() + 2);
    }

    @Override
    public void receiveGhostDrop(ItemStack stack) {
        String modId = stack.m_41720_().arch$registryName().m_135827_();
        this.modList.m_6702_().stream().filter(entry -> entry.modData.modId.equals(modId)).findFirst().ifPresent(modEntry -> this.modList.selectAndCenter(modEntry));
    }

    private class ModList
    extends CustomSelectionList<ModEntry> {
        private static final int ELEMENT_HEIGHT = 12;

        public ModList(Minecraft minecraft, int width, int height, int top, int bottom) {
            super(minecraft, width, height, top, bottom, 12);
            this.addChildren();
        }

        @Override
        protected List<ModEntry> buildChildrenList() {
            return ModConfigScreen.this.matchingModData.stream().map(x$0 -> new ModEntry((ModData)x$0)).toList();
        }

        private class ModEntry
        extends CustomSelectionList.Entry<ModEntry> {
            private final ModData modData;

            private ModEntry(ModData modData) {
                this.modData = modData;
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                MutableComponent txt = Component.m_237113_((String)this.modData.modId()).m_130948_(Style.f_131099_.m_178520_(0x202060)).m_7220_((Component)Component.m_237113_((String)" [")).m_7220_((Component)Component.m_237113_((String)this.modData.modName()).m_130948_(Style.f_131099_.m_178520_(8405024))).m_7220_((Component)Component.m_237113_((String)"]"));
                guiGraphics.m_280614_(ModConfigScreen.this.f_96547_, (Component)txt, left + 1, top + 1, 0x404040, false);
            }

            @Override
            protected boolean onMouseClick(double x, double y, int button, boolean isDoubleClick) {
                ModList.this.m_6987_((AbstractSelectionList.Entry)this);
                if (isDoubleClick) {
                    ModConfigScreen.this.applyChanges();
                }
                return true;
            }

            public Component m_142172_() {
                return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.modData.modId()});
            }
        }
    }

    private record ModData(String modId, String modName) implements Comparable<ModData>
    {
        @Override
        public int compareTo(@NotNull ModData modData) {
            return this.modId.compareTo(modData.modId);
        }
    }
}

