/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.api.client.gui;

import dev.ftb.mods.ftbfiltersystem.api.client.Textures;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterScreen;
import dev.ftb.mods.ftbfiltersystem.api.filter.AbstractSmartFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFilterConfigScreen<T extends SmartFilter>
extends Screen {
    protected final T filter;
    protected final AbstractFilterScreen parentScreen;
    protected final int guiWidth;
    protected final int guiHeight;
    protected int leftPos;
    protected int topPos;
    protected T modifiedFilter;
    private int updateCounter = 0;
    private boolean deleteOnCancel = false;
    private boolean changesApplied = false;
    private Rect2i bounds = new Rect2i(0, 0, 0, 0);

    public AbstractFilterConfigScreen(T filter, AbstractFilterScreen parentScreen, int guiWidth, int guiHeight) {
        super(filter.getDisplayName());
        this.filter = filter;
        this.modifiedFilter = filter;
        this.parentScreen = parentScreen;
        this.guiWidth = guiWidth;
        this.guiHeight = guiHeight + 40;
    }

    protected final void scheduleUpdate(int ticks) {
        this.updateCounter = ticks;
    }

    protected void doScheduledUpdate() {
    }

    @Nullable
    protected abstract T makeNewFilter();

    public final Rect2i getGuiBounds() {
        return this.bounds;
    }

    protected void m_7856_() {
        this.setupGuiDimensions();
        LinearLayout bottomPanel = new LinearLayout(this.leftPos, this.topPos + this.guiHeight - 25, this.guiWidth, 20, LinearLayout.Orientation.HORIZONTAL);
        ((FrameLayout)bottomPanel.m_264406_((LayoutElement)new FrameLayout(this.guiWidth / 2, 20))).m_264557_((LayoutElement)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), b -> this.applyChanges()).m_252780_(70).m_253136_());
        ((FrameLayout)bottomPanel.m_264406_((LayoutElement)new FrameLayout(this.guiWidth / 2, 20))).m_264557_((LayoutElement)Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), b -> this.m_7379_()).m_252780_(70).m_253136_());
        bottomPanel.m_264036_();
        bottomPanel.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        ImageWidget img = (ImageWidget)this.m_142416_((GuiEventListener)new ImageWidget(this.leftPos + this.guiWidth - 19, this.topPos + 3, 16, 16, Textures.INFO_ICON));
        img.m_257544_(Tooltip.m_257550_((Component)AbstractSmartFilter.getTooltip(this.filter.getId())));
    }

    public void m_86600_() {
        if (this.updateCounter > 0 && --this.updateCounter == 0) {
            this.doScheduledUpdate();
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)this.parentScreen);
        this.parentScreen.findAndSelect((SmartFilter)this.filter);
        if (!this.changesApplied && this.deleteOnCancel) {
            this.parentScreen.deleteSelectedFilter(true);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280260_(Textures.BACKGROUND, this.leftPos, this.topPos, this.guiWidth, this.guiHeight, 4, 32, 32, 0, 0);
        guiGraphics.m_280656_(this.leftPos + 3, this.leftPos + this.guiWidth - 4, this.topPos + this.guiHeight - 29, -2143272896);
        guiGraphics.m_280656_(this.leftPos + 3, this.leftPos + this.guiWidth - 4, this.topPos + this.guiHeight - 28, -2130706433);
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.leftPos + 8, this.topPos + 6, 0x404040, false);
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    protected final EditBox makeSearchEditBox(int x, int y, Supplier<String> prevStrSupplier, Consumer<String> prevStrConsumer) {
        Objects.requireNonNull(this.f_96547_);
        EditBox editBox = new EditBox(this.f_96547_, x, y, 88, 9 + 1, (Component)Component.m_237119_());
        editBox.m_94199_(15);
        editBox.m_94182_(true);
        editBox.m_94194_(true);
        editBox.m_94202_(0xFFFFFF);
        editBox.m_94144_(prevStrSupplier.get());
        editBox.m_94151_(s -> {
            if (!s.equals(prevStrSupplier.get())) {
                this.scheduleUpdate(5);
                prevStrConsumer.accept((String)s);
            }
        });
        this.m_142416_((GuiEventListener)editBox);
        this.m_7522_((GuiEventListener)editBox);
        return editBox;
    }

    private void setupGuiDimensions() {
        this.leftPos = (this.f_96543_ - this.guiWidth) / 2;
        this.topPos = (this.f_96544_ - this.guiHeight) / 2;
        this.bounds = new Rect2i(this.leftPos, this.topPos, this.f_96543_, this.f_96544_);
    }

    protected final void applyChanges() {
        T newFilter = this.makeNewFilter();
        if (newFilter != null) {
            this.parentScreen.replaceFilter(this.filter, newFilter);
            this.changesApplied = true;
        }
        this.m_7379_();
    }

    public void setDeleteOnCancel(boolean deleteOnCancel) {
        this.deleteOnCancel = deleteOnCancel;
    }
}

