/*
 * Decompiled with CFR 0.152.
 */
package net.jaspr.fasterladderclimbing;

import net.jaspr.fasterladderclimbing.FasterLadderClimbingConfig;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="fasterladderclimbing")
public class FasterLadderClimbing {
    public static final String MOD_ID = "fasterladderclimbing";
    public static final Logger LOGGER = LogManager.getLogger((String)"fasterladderclimbing");

    public FasterLadderClimbing() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)FasterLadderClimbingConfig.CONFIG_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.START && (player = event.player).m_6147_() && !player.m_6047_()) {
            EntityClimber climber = new EntityClimber(player);
            if (FasterLadderClimbingConfig.allowQuickDescension && climber.isFacingDownward() && !climber.isMovingForward() && !climber.isMovingBackward()) {
                climber.moveDownFarther();
            } else if (FasterLadderClimbingConfig.allowQuickAscension && climber.isFacingUpward() && climber.isMovingForward()) {
                climber.moveUpFarther();
            }
        }
    }

    private class EntityClimber {
        private Player player;

        public EntityClimber(Player player) {
            this.player = player;
        }

        private boolean isFacingDownward() {
            return this.player.m_146909_() > 0.0f;
        }

        private boolean isFacingUpward() {
            return this.player.m_146909_() < 0.0f;
        }

        private boolean isMovingForward() {
            return this.player.f_20902_ > 0.0f;
        }

        private boolean isMovingBackward() {
            return this.player.f_20902_ < 0.0f;
        }

        private float getElevationChangeUpdate() {
            return (float)Math.abs((double)this.player.m_146909_() / 90.0) * ((float)FasterLadderClimbingConfig.speedModifier / 10.0f);
        }

        public void moveUpFarther() {
            boolean px = false;
            float dx = this.getElevationChangeUpdate();
            Vec3 move = new Vec3((double)px, (double)dx, (double)px);
            this.player.m_6478_(MoverType.SELF, move);
        }

        public void moveDownFarther() {
            boolean px = false;
            float dx = this.getElevationChangeUpdate();
            Vec3 move = new Vec3((double)px, (double)(dx * -1.0f), (double)px);
            this.player.m_6478_(MoverType.SELF, move);
        }
    }
}

