/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor;

import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorLine;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;

public class IndentationGuideRenderer {
    private final TextEditorScreen editor;
    private final Color guideColor;
    private int indentSize = 2;
    private final Map<Integer, List<IndentGuide>> lineGuides = new HashMap<Integer, List<IndentGuide>>();
    private boolean needsUpdate = true;

    public IndentationGuideRenderer(TextEditorScreen editor) {
        this.editor = editor;
        this.guideColor = new Color(100, 100, 100, 60);
    }

    public void markDirty() {
        this.needsUpdate = true;
    }

    public void render(GuiGraphics graphics) {
        if (this.needsUpdate) {
            this.detectIndentationSize();
            this.calculateIndentGuidePositions();
            this.needsUpdate = false;
        }
        int charWidth = Minecraft.m_91087_().f_91062_.m_92895_(" ");
        for (TextEditorLine line : this.editor.getLines()) {
            if (!line.isInEditorArea()) continue;
            int lineIndex = line.lineIndex;
            List guides = this.lineGuides.getOrDefault(lineIndex, Collections.emptyList());
            int lineY = line.m_252907_();
            int lineHeight = line.m_93694_();
            for (IndentGuide guide : guides) {
                int xPos = line.m_252754_() + guide.indentPosition * charWidth;
                int yPos = lineY;
                int height = lineHeight;
                if (guide.type == GuideType.START) {
                    yPos = lineY + lineHeight / 2;
                    height = lineHeight / 2;
                } else if (guide.type == GuideType.END) {
                    height = lineHeight / 2;
                }
                graphics.m_285944_(RenderType.m_285907_(), xPos, yPos, xPos + 1, yPos + height, this.guideColor.getRGB());
            }
        }
    }

    private void detectIndentationSize() {
        HashMap<Integer, Integer> indentSizeCounts = new HashMap<Integer, Integer>();
        int maxCount = 0;
        int detectedSize = this.indentSize;
        for (int i = 1; i < this.editor.getLineCount(); ++i) {
            int diff;
            TextEditorLine prevLine = this.editor.getLine(i - 1);
            TextEditorLine line = this.editor.getLine(i);
            if (prevLine == null || line == null) continue;
            int prevSpaces = this.getLeadingSpaces(prevLine.m_94155_());
            int spaces = this.getLeadingSpaces(line.m_94155_());
            if (spaces <= prevSpaces || line.m_94155_().trim().isEmpty() || prevLine.m_94155_().trim().isEmpty() || (diff = spaces - prevSpaces) <= 0 || diff > 8) continue;
            indentSizeCounts.put(diff, indentSizeCounts.getOrDefault(diff, 0) + 1);
            if ((Integer)indentSizeCounts.get(diff) <= maxCount) continue;
            maxCount = (Integer)indentSizeCounts.get(diff);
            detectedSize = diff;
        }
        if (maxCount >= 2) {
            this.indentSize = detectedSize;
        }
    }

    private int getLeadingSpaces(String text) {
        int count = 0;
        for (int i = 0; i < text.length() && text.charAt(i) == ' '; ++i) {
            ++count;
        }
        return count;
    }

    private void calculateIndentGuidePositions() {
        this.lineGuides.clear();
        HashMap<Integer, Set<Integer>> activeIndentLevels = new HashMap<Integer, Set<Integer>>();
        this.analyzeLinesForIndentation(activeIndentLevels);
        this.processEmptyLines(activeIndentLevels);
        this.generateGuidesFromIndentLevels(activeIndentLevels);
    }

    private void analyzeLinesForIndentation(Map<Integer, Set<Integer>> activeIndentLevels) {
        HashMap<Integer, IndentBlock> openBlocks = new HashMap<Integer, IndentBlock>();
        for (int i = 0; i < this.editor.getLineCount(); ++i) {
            String content;
            String trimmed;
            TextEditorLine line = this.editor.getLine(i);
            if (line == null || (trimmed = (content = line.m_94155_()).trim()).isEmpty()) continue;
            int spaces = this.getLeadingSpaces(content);
            int level = spaces / this.indentSize;
            HashSet<Integer> levels = new HashSet<Integer>();
            for (int l = 1; l <= level; ++l) {
                levels.add(l);
            }
            activeIndentLevels.put(i, levels);
            if (level > 0) {
                boolean isBlockEnd;
                if (!openBlocks.containsKey(level)) {
                    openBlocks.put(level, new IndentBlock(level, i));
                }
                boolean bl = isBlockEnd = this.isBracketClosingLine(trimmed) || i + 1 < this.editor.getLineCount() && this.getNextNonEmptyLine(i) >= 0 && this.getIndentLevel(this.editor.getLine(this.getNextNonEmptyLine(i))) < level;
                if (!isBlockEnd) continue;
                openBlocks.remove(level);
                for (int l = level + 1; l < 20; ++l) {
                    openBlocks.remove(l);
                }
                continue;
            }
            openBlocks.clear();
        }
    }

    private void processEmptyLines(Map<Integer, Set<Integer>> activeIndentLevels) {
        for (int i = 0; i < this.editor.getLineCount(); ++i) {
            String content;
            String trimmed;
            TextEditorLine line = this.editor.getLine(i);
            if (line == null || !(trimmed = (content = line.m_94155_()).trim()).isEmpty()) continue;
            int prevNonEmptyIndex = this.getPrevNonEmptyLine(i);
            int nextNonEmptyIndex = this.getNextNonEmptyLine(i);
            if (prevNonEmptyIndex < 0 || nextNonEmptyIndex < 0) continue;
            Set prevLevels = activeIndentLevels.getOrDefault(prevNonEmptyIndex, Collections.emptySet());
            Set nextLevels = activeIndentLevels.getOrDefault(nextNonEmptyIndex, Collections.emptySet());
            HashSet commonLevels = new HashSet(prevLevels);
            commonLevels.retainAll(nextLevels);
            if (commonLevels.isEmpty()) continue;
            activeIndentLevels.put(i, commonLevels);
        }
    }

    private void generateGuidesFromIndentLevels(Map<Integer, Set<Integer>> activeIndentLevels) {
        for (int i = 0; i < this.editor.getLineCount(); ++i) {
            Set levels = activeIndentLevels.getOrDefault(i, Collections.emptySet());
            if (levels.isEmpty()) continue;
            Iterator iterator = levels.iterator();
            while (iterator.hasNext()) {
                int level = (Integer)iterator.next();
                int indentPos = level * this.indentSize;
                GuideType type = GuideType.MIDDLE;
                if (!activeIndentLevels.getOrDefault(i - 1, Collections.emptySet()).contains(level)) {
                    type = GuideType.START;
                }
                if (!activeIndentLevels.getOrDefault(i + 1, Collections.emptySet()).contains(level)) {
                    type = type == GuideType.START ? GuideType.MIDDLE : GuideType.END;
                }
                this.addGuide(i, indentPos, type);
            }
        }
    }

    private int getPrevNonEmptyLine(int currentLine) {
        for (int i = currentLine - 1; i >= 0; --i) {
            TextEditorLine line = this.editor.getLine(i);
            if (line == null || line.m_94155_().trim().isEmpty()) continue;
            return i;
        }
        return -1;
    }

    private int getNextNonEmptyLine(int currentLine) {
        for (int i = currentLine + 1; i < this.editor.getLineCount(); ++i) {
            TextEditorLine line = this.editor.getLine(i);
            if (line == null || line.m_94155_().trim().isEmpty()) continue;
            return i;
        }
        return -1;
    }

    private boolean isBracketOpeningLine(String trimmed) {
        return trimmed.endsWith("{") || trimmed.endsWith("[") || trimmed.endsWith("(");
    }

    private boolean isBracketClosingLine(String trimmed) {
        return trimmed.startsWith("}") || trimmed.startsWith("]") || trimmed.startsWith(")");
    }

    private int getIndentLevel(TextEditorLine line) {
        if (line == null) {
            return 0;
        }
        return this.getLeadingSpaces(line.m_94155_()) / this.indentSize;
    }

    private void addGuide(int lineIndex, int indentPosition, GuideType type) {
        this.lineGuides.computeIfAbsent(lineIndex, k -> new ArrayList()).add(new IndentGuide(indentPosition, type));
    }

    private static class IndentGuide {
        final int indentPosition;
        GuideType type;

        IndentGuide(int indentPosition, GuideType type) {
            this.indentPosition = indentPosition;
            this.type = type;
        }
    }

    private static enum GuideType {
        START,
        MIDDLE,
        END;

    }

    private static class IndentBlock {
        final int level;
        final int startLine;

        IndentBlock(int level, int startLine) {
            this.level = level;
            this.startLine = startLine;
        }
    }
}

