/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.buddy.items;

import de.keksuccino.fancymenu.customization.layout.editor.buddy.Buddy;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class Poop {
    public static final ResourceLocation TEXTURE_POOP = new ResourceLocation("fancymenu", "textures/buddy/poop.png");
    public int x;
    public int y;
    public final int size = 16;
    public boolean isBeingCleaned = false;
    public int cleaningAnimation = 0;
    public static final int CLEANING_DURATION = 20;
    public float relativeX;
    public float relativeY;
    public final Buddy buddy;

    public Poop(int x, int y, Buddy buddy) {
        this.x = x;
        this.y = y;
        this.buddy = buddy;
        int screenWidth = buddy.getScreenWidth();
        int screenHeight = buddy.getScreenHeight();
        if (screenWidth <= 0 || screenHeight <= 0) {
            this.relativeX = 0.5f;
            this.relativeY = 0.9f;
            return;
        }
        this.x = Math.min(Math.max(x, 0), screenWidth);
        this.y = Math.min(Math.max(y, 0), screenHeight);
        this.relativeX = (float)this.x / (float)screenWidth;
        this.relativeY = (float)this.y / (float)screenHeight;
    }

    public void render(GuiGraphics graphics) {
        if (this.isBeingCleaned) {
            float alpha = 1.0f - (float)this.cleaningAnimation / 20.0f;
            int color = (int)(alpha * 255.0f) << 24 | 0xFFFFFF;
            DrawableColor.of(color).setAsShaderColor(graphics);
            graphics.m_280163_(TEXTURE_POOP, this.x - 8, this.y - 8, 0.0f, 0.0f, 16, 16, 16, 16);
            RenderingUtils.resetShaderColor(graphics);
        } else {
            graphics.m_280163_(TEXTURE_POOP, this.x - 8, this.y - 8, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    public void tick() {
        if (this.isBeingCleaned) {
            this.cleaningAnimation += 2;
        }
    }

    public void updatePosition(int screenWidth, int screenHeight) {
        if (screenWidth <= 0 || screenHeight <= 0) {
            return;
        }
        this.x = (int)(this.relativeX * (float)screenWidth);
        this.y = (int)(this.relativeY * (float)screenHeight);
        this.x = Math.min(Math.max(this.x, 10), screenWidth - 10);
        this.y = Math.min(Math.max(this.y, 10), screenHeight - 10);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)(this.x - 8) && mouseX < (double)(this.x + 8) && mouseY >= (double)(this.y - 8) && mouseY < (double)(this.y + 8);
    }

    public void startCleaning() {
        if (!this.isBeingCleaned) {
            this.isBeingCleaned = true;
            this.cleaningAnimation = 0;
        } else {
            this.cleaningAnimation = 20;
        }
    }

    public boolean shouldRemove() {
        return this.isBeingCleaned && this.cleaningAnimation >= 20;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

