/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.browser;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiBaseScreen;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.mcef.BrowserHandler;
import de.keksuccino.fancymenu.util.mcef.MCEFUtil;
import de.keksuccino.fancymenu.util.mcef.WrappedMCEFBrowser;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.konkrete.input.MouseInput;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DrawableColor ERROR_BACKGROUND_COLOR = DrawableColor.of(Color.RED);
    @NotNull
    public String url = "https://docs.fancymenu.net";
    public boolean interactable = true;
    public boolean hideVideoControls = false;
    public boolean loopVideos = false;
    public boolean muteMedia = false;
    public float mediaVolume = 1.0f;
    @Nullable
    public WrappedMCEFBrowser browser = null;
    public int lastTickWidth = -1;
    public int lastTickHeight = -1;
    public long lastLeftClickTime = -1L;

    public BrowserElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    @Override
    public void afterConstruction() {
        if (MCEFUtil.isMCEFLoaded() && MCEFUtil.MCEF_initialized) {
            this.browser = BrowserHandler.get(this.getInstanceIdentifier());
            if (this.browser == null) {
                this.browser = WrappedMCEFBrowser.build(PlaceholderParser.replacePlaceholders(this.url), true, false, null);
            }
            BrowserHandler.notifyHandler(this.getInstanceIdentifier(), this.browser);
        }
    }

    @Override
    public void onCloseScreen(@Nullable Screen closedScreen, @Nullable Screen newScreen) {
        if (closedScreen != null && newScreen != null) {
            boolean bothCustomGuis;
            boolean bl = bothCustomGuis = closedScreen instanceof CustomGuiBaseScreen && newScreen instanceof CustomGuiBaseScreen;
            if (closedScreen instanceof CustomGuiBaseScreen) {
                CustomGuiBaseScreen c1 = (CustomGuiBaseScreen)closedScreen;
                if (newScreen instanceof CustomGuiBaseScreen) {
                    CustomGuiBaseScreen c2 = (CustomGuiBaseScreen)newScreen;
                    if (c1.getIdentifier().equals(c2.getIdentifier())) {
                        return;
                    }
                }
            }
            if (!bothCustomGuis && closedScreen.getClass() == newScreen.getClass()) {
                return;
            }
        }
        if (this.browser != null) {
            BrowserHandler.remove(this.getInstanceIdentifier(), true);
        }
    }

    @Override
    @Nullable
    public List<GuiEventListener> getWidgetsToRegister() {
        if (this.browser == null) {
            return null;
        }
        return List.of(this.browser);
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.shouldRender()) {
            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            int w = this.getAbsoluteWidth();
            int h = this.getAbsoluteHeight();
            if (this.browser != null) {
                BrowserHandler.notifyHandler(this.getInstanceIdentifier(), this.browser);
                if (!this.browser.isHideVideoControls() && this.hideVideoControls) {
                    this.browser.setHideVideoControls(true);
                }
                if (this.browser.isHideVideoControls() && !this.hideVideoControls) {
                    this.browser.setHideVideoControls(false);
                }
                if (!this.browser.isLoopAllVideos() && this.loopVideos) {
                    this.browser.setLoopAllVideos(true);
                }
                if (this.browser.isLoopAllVideos() && !this.loopVideos) {
                    this.browser.setLoopAllVideos(false);
                }
                if (!this.browser.isMuteAllMediaOnLoad() && this.muteMedia) {
                    this.browser.setMuteAllMediaOnLoad(true);
                }
                if (this.browser.isMuteAllMediaOnLoad() && !this.muteMedia) {
                    this.browser.setMuteAllMediaOnLoad(false);
                }
                if (this.mediaVolume > 1.0f) {
                    this.mediaVolume = 1.0f;
                }
                if (this.mediaVolume < 0.0f) {
                    this.mediaVolume = 0.0f;
                }
                if (this.browser.getVolume() != this.mediaVolume) {
                    this.browser.setVolume(this.mediaVolume);
                }
                this.browser.setOpacity(this.opacity);
                this.browser.m_264152_(x, y);
                if (this.lastTickWidth != w || this.lastTickHeight != h) {
                    this.browser.setSize(w, h);
                }
                this.lastTickWidth = w;
                this.lastTickHeight = h;
                String finalUrl = PlaceholderParser.replacePlaceholders(this.url);
                if (!finalUrl.equals(this.getLastTickUrl())) {
                    this.browser.setUrl(finalUrl);
                    this.setLastTickUrl(finalUrl);
                }
                this.browser.setInteractable(this.interactable && !BrowserElement.isEditor());
                RenderSystem.enableBlend();
                this.browser.m_88315_(graphics, mouseX, mouseY, partial);
                if (BrowserElement.isEditor()) {
                    if (MouseInput.isLeftMouseDown() && this.browser.m_5953_(mouseX, mouseY)) {
                        this.lastLeftClickTime = System.currentTimeMillis();
                    }
                    if (this.lastLeftClickTime + 5000L > System.currentTimeMillis()) {
                        graphics.m_280509_(x, y, x + w, y + h, ERROR_BACKGROUND_COLOR.getColorIntWithAlpha(0.4f));
                        Font font = Minecraft.m_91087_().f_91062_;
                        MutableComponent mutableComponent = Component.m_237115_((String)"fancymenu.elements.browser.disabled_in_editor").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
                        int n = x + w / 2;
                        int n2 = y + h / 2;
                        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                        graphics.m_280653_(font, (Component)mutableComponent, n, n2 - 9 / 2, -1);
                        graphics.m_280262_();
                    }
                }
            } else {
                RenderSystem.enableBlend();
                graphics.m_285944_(RenderType.m_286086_(), x, y, x + w, y + h, ERROR_BACKGROUND_COLOR.getColorInt());
                Font font = Minecraft.m_91087_().f_91062_;
                MutableComponent mutableComponent = Component.m_237115_((String)"fancymenu.elements.browser.mcef_not_loaded.line_1").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
                int n = x + w / 2;
                int n3 = y + h / 2;
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                graphics.m_280653_(font, (Component)mutableComponent, n, n3 - 9 - 2, -1);
                graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"fancymenu.elements.browser.mcef_not_loaded.line_2").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true))), x + w / 2, y + h / 2 + 2, -1);
            }
        }
    }

    @Nullable
    public String getLastTickUrl() {
        return this.getMemory().getStringProperty("last_tick_url");
    }

    public void setLastTickUrl(@Nullable String url) {
        this.getMemory().putProperty("last_tick_url", url);
    }
}

