/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_enchanting;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_enchanting.EmiClientPlugin;
import fzzyhmstrs.emi_enchanting.EmiEnchanting;
import fzzyhmstrs.emi_enchanting.widget.PageWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class EnchantmentRecipe
implements EmiRecipe {
    private final Enchantment enchantment;
    private final List<EmiStack> bookStacks;
    private final List<EmiIngredient> inputs;
    private final List<PageWidget> pageWidgets;
    private int currentPage = 0;
    private final int maxPage;

    public EnchantmentRecipe(Collection<ItemStack> books, Enchantment enchantment, Map<Enchantment, Collection<ItemStack>> enchantMap) {
        this.enchantment = enchantment;
        List<EmiStack> bookStacks = books.stream().map(EmiStack::of).toList();
        EmiIngredient books1 = EmiIngredient.of(bookStacks);
        this.bookStacks = bookStacks;
        List validItems = List.of(new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
        int counter = 0;
        for (Item item : BuiltInRegistries.f_257033_) {
            if (!enchantment.m_6081_(new ItemStack((ItemLike)item))) continue;
            ((List)validItems.get(counter % 8)).add(EmiStack.of((ItemLike)item));
            ++counter;
        }
        List<EmiIngredient> validItems1 = validItems.stream().map(EmiIngredient::of).toList();
        HashMap<Enchantment, EmiIngredient> exclusions = new HashMap<Enchantment, EmiIngredient>();
        for (Map.Entry<Enchantment, Collection<ItemStack>> entry : enchantMap.entrySet()) {
            if (entry.getKey().m_44695_(enchantment) || entry.getKey() == enchantment) continue;
            List<EmiStack> stacks = entry.getValue().stream().map(EmiStack::of).toList();
            exclusions.put(entry.getKey(), EmiIngredient.of(stacks));
        }
        ArrayList<EmiIngredient> inputs = new ArrayList<EmiIngredient>();
        inputs.add(books1);
        inputs.addAll(validItems1);
        inputs.addAll(exclusions.values());
        this.inputs = inputs;
        MutableComponent curse = Component.m_237110_((String)"emi_enchanting.curse", (Object[])new Object[]{enchantment.m_6589_() ? Component.m_237115_((String)"emi_enchanting.yes_bad") : Component.m_237115_((String)"emi_enchanting.no_bad")});
        MutableComponent treasure = Component.m_237110_((String)"emi_enchanting.treasure", (Object[])new Object[]{enchantment.m_6591_() ? Component.m_237115_((String)"emi_enchanting.yes_bad") : Component.m_237115_((String)"emi_enchanting.no_bad")});
        MutableComponent tradeable = Component.m_237110_((String)"emi_enchanting.tradeable", (Object[])new Object[]{enchantment.m_6594_() ? Component.m_237115_((String)"emi_enchanting.yes_good") : Component.m_237115_((String)"emi_enchanting.no_good")});
        MutableComponent random = Component.m_237110_((String)"emi_enchanting.random", (Object[])new Object[]{enchantment.m_6592_() ? Component.m_237115_((String)"emi_enchanting.yes_good") : Component.m_237115_((String)"emi_enchanting.no_good")});
        MutableComponent maxLvl = Component.m_237110_((String)"emi_enchanting.maxLvl", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(enchantment.m_6586_())).m_130940_(ChatFormatting.BLACK)});
        String descLangKey = enchantment.m_44704_() + ".desc";
        MutableComponent descText = Component.m_237115_((String)descLangKey);
        ArrayList<PageWidget> widgets = new ArrayList<PageWidget>();
        PageWidget firstPage = new PageWidget(0, 0, 144, 124);
        firstPage.addSlot(books1, 0, 0);
        firstPage.addText((Component)enchantment.m_44700_(1).m_6879_().m_130940_(ChatFormatting.BLACK), 22, 2, 0, false);
        firstPage.addText((Component)curse, 0, 20, 0, false);
        firstPage.addText((Component)treasure, 0, 31, 0, false);
        firstPage.addText((Component)tradeable, 0, 42, 0, false);
        firstPage.addText((Component)random, 0, 53, 0, false);
        firstPage.addText((Component)maxLvl, 0, 64, 0, false);
        firstPage.addText((Component)Component.m_237115_((String)"emi_enchanting.valid_items"), 0, 82, 0, false);
        for (int i = 0; i < 8; ++i) {
            if (((List)validItems.get(i)).isEmpty()) continue;
            firstPage.addSlot(validItems1.get(i), i * 18, 92);
        }
        if (!exclusions.isEmpty() || !Objects.equals(descText.getString(), descLangKey)) {
            firstPage.addButton(0, 112, 12, 12, 0, 0, () -> true, (mouseX, mouseY, button) -> this.previous());
            firstPage.addButton(132, 112, 12, 12, 12, 0, () -> true, (mouseX, mouseY, button) -> this.next());
        }
        firstPage.setActive(true);
        widgets.add(firstPage);
        if (!Objects.equals(descText.getString(), descLangKey)) {
            PageWidget descriptionPage = new PageWidget(0, 0, 144, 124);
            descriptionPage.addText((Component)Component.m_237115_((String)"emi_enchanting.description"), 2, 2, 0, false);
            List descriptionLines = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)descText.m_130940_(ChatFormatting.ITALIC), 140);
            int y = 16;
            for (FormattedCharSequence text : descriptionLines) {
                descriptionPage.addText(text, 2, y, 0, false);
                y += 11;
            }
            descriptionPage.addButton(0, 112, 12, 12, 0, 0, () -> true, (mouseX, mouseY, button) -> this.previous());
            descriptionPage.addButton(132, 112, 12, 12, 12, 0, () -> true, (mouseX, mouseY, button) -> this.next());
            widgets.add(descriptionPage);
        }
        int exclusionsIndex = 0;
        List exclusionsList = exclusions.entrySet().stream().toList();
        while (exclusionsIndex < exclusions.size()) {
            PageWidget exclusionPage = new PageWidget(0, 0, 144, 124);
            exclusionPage.addText((Component)Component.m_237115_((String)"emi_enchanting.exclusions"), 0, 0, 0, false);
            for (int i = 0; i < 5; ++i) {
                int y = 14 + 20 * i;
                exclusionPage.addSlot((EmiIngredient)((Map.Entry)exclusionsList.get(exclusionsIndex)).getValue(), 0, y);
                exclusionPage.addText((Component)((Enchantment)((Map.Entry)exclusionsList.get(exclusionsIndex)).getKey()).m_44700_(1).m_6879_().m_130940_(ChatFormatting.BLACK), 20, y, 0, false);
                if (++exclusionsIndex >= exclusionsList.size()) break;
            }
            exclusionPage.addButton(0, 112, 12, 12, 0, 0, () -> true, (mouseX, mouseY, button) -> this.previous());
            exclusionPage.addButton(132, 112, 12, 12, 12, 0, () -> true, (mouseX, mouseY, button) -> this.next());
            widgets.add(exclusionPage);
        }
        this.pageWidgets = widgets;
        this.maxPage = this.pageWidgets.size() - 1;
    }

    private void previous() {
        for (PageWidget widget : this.pageWidgets) {
            widget.setActive(false);
        }
        --this.currentPage;
        if (this.currentPage < 0) {
            this.currentPage = this.maxPage;
        }
        this.pageWidgets.get(this.currentPage).setActive(true);
    }

    private void next() {
        for (PageWidget widget : this.pageWidgets) {
            widget.setActive(false);
        }
        ++this.currentPage;
        if (this.currentPage > this.maxPage) {
            this.currentPage = 0;
        }
        this.pageWidgets.get(this.currentPage).setActive(true);
    }

    public EmiRecipeCategory getCategory() {
        return EmiClientPlugin.ENCHANTING_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        ResourceLocation id = BuiltInRegistries.f_256876_.m_7981_((Object)this.enchantment);
        if (id == null) {
            return null;
        }
        return new ResourceLocation(EmiEnchanting.MOD_ID, "/" + id.m_214298_() + "/enchanting_info");
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiIngredient> getCatalysts() {
        return super.getCatalysts();
    }

    public List<EmiStack> getOutputs() {
        return this.bookStacks;
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        return 124;
    }

    public void addWidgets(WidgetHolder widgets) {
        for (PageWidget widget : this.pageWidgets) {
            widgets.add((Widget)widget);
        }
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }
}

