/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.fluids.IMaterialFormFluidBlock;
import thelm.jaopca.api.fluids.PlaceableFluid;
import thelm.jaopca.api.fluids.PlaceableFluidBlock;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.functions.MemoizingSuppliers;
import thelm.jaopca.api.materials.IMaterial;

public class JAOPCAFluidBlock
extends PlaceableFluidBlock
implements IMaterialFormFluidBlock {
    private final IMaterialFormFluid fluid;
    protected final IFluidFormSettings settings;
    protected Supplier<MapColor> mapColor;
    protected IntSupplier lightValue;
    protected DoubleSupplier explosionResistance;
    protected IntSupplier flammability;
    protected IntSupplier fireSpreadSpeed;
    protected BooleanSupplier isFireSource;
    protected IntSupplier fireTime;

    public JAOPCAFluidBlock(IMaterialFormFluid fluid, IFluidFormSettings settings) {
        super(JAOPCAFluidBlock.getProperties(fluid, settings), (PlaceableFluid)fluid.toFluid(), settings.getMaxLevelFunction().applyAsInt(fluid.getMaterial()));
        this.fluid = fluid;
        this.settings = settings;
        this.mapColor = MemoizingSuppliers.of(settings.getMapColorFunction(), fluid::getMaterial);
        this.lightValue = MemoizingSuppliers.of(settings.getLightValueFunction(), fluid::getMaterial);
        this.explosionResistance = MemoizingSuppliers.of(settings.getExplosionResistanceFunction(), fluid::getMaterial);
        this.flammability = MemoizingSuppliers.of(settings.getFlammabilityFunction(), fluid::getMaterial);
        this.fireSpreadSpeed = MemoizingSuppliers.of(settings.getFireSpreadSpeedFunction(), fluid::getMaterial);
        this.isFireSource = MemoizingSuppliers.of(settings.getIsFireSourceFunction(), fluid::getMaterial);
        this.fireTime = MemoizingSuppliers.of(settings.getFireTimeFunction(), fluid::getMaterial);
    }

    public static BlockBehaviour.Properties getProperties(IMaterialFormFluid fluid, IFluidFormSettings settings) {
        BlockBehaviour.Properties prop = BlockBehaviour.Properties.m_284310_();
        prop.m_60978_((float)settings.getBlockHardnessFunction().applyAsDouble(fluid.getMaterial()));
        prop.m_60953_(state -> settings.getLightValueFunction().applyAsInt(fluid.getMaterial()));
        prop.m_60910_();
        prop.m_60977_();
        prop.m_222994_();
        prop.m_60955_();
        prop.m_280170_();
        prop.m_278788_();
        prop.m_278166_(PushReaction.DESTROY);
        return prop;
    }

    @Override
    public IForm getForm() {
        return this.fluid.getForm();
    }

    @Override
    public IMaterial getMaterial() {
        return this.fluid.getMaterial();
    }

    public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        return this.mapColor.get();
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return this.lightValue.getAsInt();
    }

    public float m_7325_() {
        return (float)this.explosionResistance.getAsDouble();
    }

    public int getFlammability(BlockState blockState, BlockGetter world, BlockPos pos, Direction face) {
        return this.flammability.getAsInt();
    }

    public int getFireSpreadSpeed(BlockState blockState, BlockGetter world, BlockPos pos, Direction face) {
        return this.fireSpreadSpeed.getAsInt();
    }

    public boolean isFireSource(BlockState blockState, LevelReader world, BlockPos pos, Direction side) {
        return this.isFireSource.getAsBoolean();
    }

    public void m_7892_(BlockState blockState, Level world, BlockPos pos, Entity entity) {
        int time = this.fireTime.getAsInt();
        if (time > 0) {
            entity.m_20254_(time);
        }
    }
}

