/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.thermalexpansion.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class PulverizerRecycleRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object[] output;
    public final int energy;
    public final float experience;

    public PulverizerRecycleRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object[] output, int energy, float experience) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.energy = energy;
        this.experience = experience;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        ArrayList<Pair> outputs = new ArrayList<Pair>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(-1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).m_41619_()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(Pair.of((Object)stack, (Object)chance));
        }
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + String.valueOf(this.key) + ": " + Arrays.deepToString(this.output));
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "thermal:pulverizer_recycle");
        JsonArray ingsJson = new JsonArray();
        JsonObject ingJson = new JsonObject();
        ingJson.add("value", ing.m_43942_());
        ingJson.addProperty("count", (Number)this.inputCount);
        ingsJson.add((JsonElement)ingJson);
        json.add("ingredients", (JsonElement)ingsJson);
        JsonArray resultJson = new JsonArray();
        for (Pair out : outputs) {
            JsonObject itemResultJson = MiscHelper.INSTANCE.serializeItemStack((ItemStack)out.getLeft());
            itemResultJson.addProperty("chance", (Number)out.getRight());
            resultJson.add((JsonElement)itemResultJson);
        }
        json.add("result", (JsonElement)resultJson);
        json.addProperty("energy", (Number)this.energy);
        json.addProperty("experience", (Number)Float.valueOf(this.experience));
        return json;
    }
}

