/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.railcraft;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.railcraft.RailcraftHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"railcraft"})
public class RailcraftCompatModule
implements IModule {
    private static final Set<String> TO_DUST_BLACKLIST = new TreeSet<String>(List.of("bronze", "charcoal", "coal", "coal_coke", "copper", "diamond", "emerald", "ender_pearl", "gold", "iron", "lapis", "lead", "netherite", "nickel", "prismarine", "quartz", "silver", "steel", "tin"));
    private static final Set<String> TO_PLATE_BLACKLIST = new TreeSet<String>(List.of("brass", "bronze", "copper", "gold", "invar", "iron", "lead", "nickel", "silver", "steel", "tin", "zinc"));
    private static Set<String> configToDustBlacklist = new TreeSet<String>();
    private static Set<String> configToPlateBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "railcraft_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toDustMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have crusher to dust recipes added."), configToDustBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toCrystalMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have rolling to plate recipes added."), configToPlateBlacklist);
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        RailcraftHelper helper = RailcraftHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<ResourceLocation> itemTags = ((JAOPCAApi)api).getItemTags();
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation materialLocation;
            MaterialType type = material.getType();
            String name = material.getName();
            if (!(type.isDust() || TO_DUST_BLACKLIST.contains(name) || configToDustBlacklist.contains(name))) {
                materialLocation = miscHelper.getTagLocation(type.getFormName(), name);
                ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", name);
                if (itemTags.contains(dustLocation)) {
                    helper.registerCrusherRecipe(new ResourceLocation("jaopca", "railcraft.material_to_dust." + name), materialLocation, 200, dustLocation, 1, Float.valueOf(1.0f));
                }
            }
            if (!type.isIngot() || TO_PLATE_BLACKLIST.contains(name) || configToPlateBlacklist.contains(name)) continue;
            materialLocation = miscHelper.getTagLocation(type.getFormName(), name);
            ResourceLocation plateLocation = miscHelper.getTagLocation("plates", name);
            if (!itemTags.contains(plateLocation)) continue;
            helper.registerRollingRecipe(new ResourceLocation("jaopca", "railcraft.material_to_plate." + name), plateLocation, 4, 100, "AA", "AA", Character.valueOf('A'), materialLocation);
        }
    }
}

