/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import mekanism.api.MekanismAPI;
import net.minecraft.resources.ResourceLocation;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.data.DataCollector;
import thelm.jaopca.utils.ApiImpl;

public class MekanismDataInjector {
    public static final Set<ResourceLocation> GAS_TAG_BLACKLIST = new TreeSet<ResourceLocation>();
    public static final Set<ResourceLocation> INFUSE_TYPE_TAG_BLACKLIST = new TreeSet<ResourceLocation>();
    public static final Set<ResourceLocation> PIGMENT_TAG_BLACKLIST = new TreeSet<ResourceLocation>();
    public static final Set<ResourceLocation> SLURRY_TAG_BLACKLIST = new TreeSet<ResourceLocation>();

    private MekanismDataInjector() {
    }

    public static boolean registerGasTag(ResourceLocation location, Supplier<ResourceLocation> gasLocation) {
        if (GAS_TAG_BLACKLIST.contains(location)) {
            return false;
        }
        return ApiImpl.INSTANCE.registerTag(MekanismAPI.GAS_REGISTRY_NAME, location, gasLocation);
    }

    public static boolean registerGasTag(ResourceLocation location, ResourceLocation gasLocation) {
        return MekanismDataInjector.registerGasTag(location, () -> gasLocation);
    }

    public static boolean registerInfuseTypeTag(ResourceLocation location, Supplier<ResourceLocation> infuseTypeLocation) {
        if (INFUSE_TYPE_TAG_BLACKLIST.contains(location)) {
            return false;
        }
        return ApiImpl.INSTANCE.registerTag(MekanismAPI.INFUSE_TYPE_REGISTRY_NAME, location, infuseTypeLocation);
    }

    public static boolean registerInfuseTypeTag(ResourceLocation location, ResourceLocation infuseTypeLocation) {
        return MekanismDataInjector.registerInfuseTypeTag(location, () -> infuseTypeLocation);
    }

    public static boolean registerPigmentTag(ResourceLocation location, Supplier<ResourceLocation> pigmentLocation) {
        if (PIGMENT_TAG_BLACKLIST.contains(location)) {
            return false;
        }
        return ApiImpl.INSTANCE.registerTag(MekanismAPI.PIGMENT_REGISTRY_NAME, location, pigmentLocation);
    }

    public static boolean registerPigmentTag(ResourceLocation location, ResourceLocation pigmentLocation) {
        return MekanismDataInjector.registerPigmentTag(location, () -> pigmentLocation);
    }

    public static boolean registerSlurryTag(ResourceLocation location, Supplier<ResourceLocation> slurryLocation) {
        if (SLURRY_TAG_BLACKLIST.contains(location)) {
            return false;
        }
        return ApiImpl.INSTANCE.registerTag(MekanismAPI.SLURRY_REGISTRY_NAME, location, slurryLocation);
    }

    public static boolean registerSlurryTag(ResourceLocation location, ResourceLocation slurryLocation) {
        return MekanismDataInjector.registerSlurryTag(location, () -> slurryLocation);
    }

    static void setupConfig(IDynamicSpecConfig config) {
        config.setComment("gasTags", "Configurations related to gas tags.");
        GAS_TAG_BLACKLIST.addAll(Lists.transform(config.getDefinedStringList("gasTags.blacklist", new ArrayList<String>(), "List of gas tags that should not be added."), ResourceLocation::new));
        DataCollector.getDefinedTags(MekanismAPI.GAS_REGISTRY_NAME).addAll(Lists.transform(config.getDefinedStringList("gasTags.customDefined", new ArrayList<String>(), "List of gas tags that should be considered as defined."), ResourceLocation::new));
        config.setComment("infuseTypeTags", "Configurations related to infuse type tags.");
        INFUSE_TYPE_TAG_BLACKLIST.addAll(Lists.transform(config.getDefinedStringList("infuseTypeTags.blacklist", new ArrayList<String>(), "List of infuse type tags that should not be added."), ResourceLocation::new));
        DataCollector.getDefinedTags(MekanismAPI.INFUSE_TYPE_REGISTRY_NAME).addAll(Lists.transform(config.getDefinedStringList("infuseTypeTags.customDefined", new ArrayList<String>(), "List of infuse type tags that should be considered as defined."), ResourceLocation::new));
        config.setComment("pigmentTags", "Configurations related to pigment tags.");
        PIGMENT_TAG_BLACKLIST.addAll(Lists.transform(config.getDefinedStringList("pigmentTags.blacklist", new ArrayList<String>(), "List of infuse type tags that should not be added."), ResourceLocation::new));
        DataCollector.getDefinedTags(MekanismAPI.PIGMENT_REGISTRY_NAME).addAll(Lists.transform(config.getDefinedStringList("pigmentTags.customDefined", new ArrayList<String>(), "List of infuse type tags that should be considered as defined."), ResourceLocation::new));
        config.setComment("slurryTags", "Configurations related to slurry tags.");
        SLURRY_TAG_BLACKLIST.addAll(Lists.transform(config.getDefinedStringList("slurryTags.blacklist", new ArrayList<String>(), "List of infuse type tags that should not be added."), ResourceLocation::new));
        DataCollector.getDefinedTags(MekanismAPI.SLURRY_REGISTRY_NAME).addAll(Lists.transform(config.getDefinedStringList("slurryTags.customDefined", new ArrayList<String>(), "List of infuse type tags that should be considered as defined."), ResourceLocation::new));
    }
}

